package com.luxof.lapisworks.mishaps;

import static com.luxof.lapisworks.LapisworksIDs.NOT_EQUIPPED;

import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;

public class MishapNotWearingTrinket extends Mishap {
    private final class_1792 trinket;

    public MishapNotWearingTrinket(@NotNull class_1792 requiredTrinket) {
        this.trinket = requiredTrinket;
    }

    @Override
    public FrozenPigment accentColor(CastingEnvironment arg0, Context arg1) {
        return dyeColor(class_1767.field_7951);
    }

    @Override
    public void execute(CastingEnvironment arg0, Context arg1, List<Iota> arg2) {}

    @Override
    protected class_2561 errorMessage(CastingEnvironment arg0, Context arg1) {
        return class_2561.method_43469(
            NOT_EQUIPPED,
            this.trinket.method_7848()
        );
    }
}
