package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;

import com.luxof.lapisworks.blocks.stuff.LinkableMediaBlock;

import static com.luxof.lapisworks.Lapisworks.LOGGER;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1278;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = BlockEntityAbstractImpetus.class, remap = false)
public abstract class BlockEntityAbstractImpetusMixin extends HexBlockEntity implements class_1278, LinkableMediaBlock {
    public BlockEntityAbstractImpetusMixin(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) { super(pType, pWorldPosition, pBlockState); }

    @Unique
    private static final long MAX_CAPACITY = 9_000_000_000_000_000_000L;
    @Unique
    private HashSet<class_2338> linked = new HashSet<>();
    @Shadow
    protected long media;

    @Override
    public void addLink(class_2338 pos) {
        linked.add(pos);
    }

    @Override
    public void removeLink(class_2338 pos) {
        linked.remove(pos);
    }

    @Override
    public boolean isLinkedTo(class_2338 pos) {
        return linked.contains(pos);
    }

    @Override
    public Set<class_2338> getLinks() {
        return linked;
    }

    @Override
    public int getNumberOfLinks() {
        return linked.size();
    }

    @Override
    public int getMaxNumberOfLinks() {
        return 1;
    }

    @Override
    public class_2338 getThisPos() {
        return method_11016();
    }

    @Override
    public long depositMedia(long amount, boolean simulate) {
        return 0;
    }

    @Override
    public long withdrawMedia(long amount, boolean simulate) {
        LOGGER.info("impetus got a withdrawal: " + amount + ", sim " + String.valueOf(simulate));
        return 0;
    }


    private List<Integer> posToInts(HashSet<class_2338> posList) {
        return posList.stream().flatMap(
            pos -> Stream.of(pos.method_10263(), pos.method_10264(), pos.method_10260())
        ).toList();
    }
    @Inject(
        method = "saveModData",
        at = @At("HEAD")
    )
    protected void saveModData(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10572(
            "links",
            posToInts(linked)
        );
    }

    private HashSet<class_2338> intsToPos(int[] intArray) {
        HashSet<class_2338> posList = new HashSet<>();
        int x = 0;
        int y = 0;
        int part = 0;
        for (int integer : intArray) {
            switch (part) {
                case 0 -> x = integer;
                case 1 -> y = integer;
                case 2 -> posList.add(new class_2338(x, y, integer));
                default -> {}
            };
            part = (part + 1) % 3;
        }
        return posList;
    }
    @Inject(
        method = "loadModData",
        at = @At("HEAD")
    )
    protected void loadModData(class_2487 nbt, CallbackInfo ci) {
        linked = intsToPos(nbt.method_10561("links"));
    }
}
