package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.luxof.lapisworks.interop.hexical.blocks.HolderEntity;

import static com.luxof.lapisworks.LapisworksIDs.HEXICAL_IMPETUS_HAND;
import static com.luxof.lapisworks.LapisworksIDs.RH_HOLDER;
import static com.luxof.lapisworks.Lapisworks.HEXICAL_INTEROP;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import miyucomics.hexical.features.pedestal.PedestalBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// slightly higher prio than Miyu's mixin
// this should make my stuff run before hers
// also makes this run before Slate Works' i think
// so if Slate Works and Hexical disagreed on where the funcs should go first
// i decide that pedestals have the first turn (unintended but ok)
@Mixin(value = CircleCastEnv.class, remap = false, priority = 999)
public abstract class CircleCastEnvMixin extends CastingEnvironment {
    protected CircleCastEnvMixin(class_3218 world) { super(world); }

    @Shadow
    public abstract CircleExecutionState circleState();

    @WrapMethod(method = {"getPrimaryStacks"})
    public List<HeldItemInfo> getPrimaryStacks(Operation<List<HeldItemInfo>> og) {
        List<HeldItemInfo> init = new ArrayList<>(og.call(new Object[0]));
        if (!HEXICAL_INTEROP) return init;

        class_2487 userData = this.circleState().currentImage.getUserData();
        if (userData.method_10545(HEXICAL_IMPETUS_HAND)) {
            init.add(new HeldItemInfo(this.getPedestal().method_5438(0), class_1268.field_5810));
        }
        if (userData.method_10545(RH_HOLDER)) {
            init.add(this.getRightHandedHolder().heldInfo);
        }
        return init;
    }

    @Inject(method = {"replaceItem"}, at = {@At("HEAD")}, cancellable = true)
    public void replaceItem(
        Predicate<class_1799> stackOk,
        class_1799 replaceWith,
        @NotNull class_1268 hand,
        CallbackInfoReturnable<Boolean> cir
    ) {
        if (!HEXICAL_INTEROP) return;
        class_2487 userData = this.circleState().currentImage.getUserData();
        // null check because some monkey (me) may use 4 hands
        if (userData.method_10545(HEXICAL_IMPETUS_HAND) && (hand == class_1268.field_5810 || hand == null)) {
            class_1263 LHInv = (class_1263)this.getPedestal();
            if (stackOk.test(LHInv.method_5438(0))) {
                LHInv.method_5447(0, replaceWith);
                cir.setReturnValue(true);
            }
        }
        if (userData.method_10545(RH_HOLDER) && (hand == class_1268.field_5808 || hand == null)) {
            class_1263 RHInv = (class_1263)this.getRightHandedHolder();
            if (stackOk.test(RHInv.method_5438(0))) {
                RHInv.method_5447(0, replaceWith);
                cir.setReturnValue(true);
            }
        }
    }

    @Unique
    private HolderEntity getRightHandedHolder() {
        if (!HEXICAL_INTEROP) return null;
        int[] p = this.circleState().currentImage.getUserData().method_10561(RH_HOLDER);
        HolderEntity holder = (HolderEntity)this.getWorld().method_8321(
            new class_2338(p[0], p[1], p[2])
        );

        assert holder != null;

        return holder;
    }

    @Unique
    private PedestalBlockEntity getPedestal() {
        if (!HEXICAL_INTEROP) return null;
        int[] position = this.circleState().currentImage.getUserData().method_10561("impetus_hand");
        class_3218 world = this.getWorld();
        PedestalBlockEntity pedestal = (PedestalBlockEntity)world.method_8321(
            new class_2338(position[0], position[1], position[2])
        );

        assert pedestal != null;

        return pedestal;
    }
}
