package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.utils.NBTHelper;

import com.luxof.lapisworks.interop.hexical.blocks.CradleEntity;
import com.luxof.lapisworks.mixinsupport.ItemEntityMinterface;
import net.minecraft.class_1542;
import net.minecraft.class_2338;

import static com.luxof.lapisworks.LapisworksIDs.IS_IN_CRADLE;

import org.jetbrains.annotations.NotNull;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets = {
    "miyucomics.hexical.features.wristpocket.OpSleight$SwapSpell",
    "miyucomics.hexical.casting.patterns.wristpocket.OpSleight$SwapSpell"
}, remap = false)
public abstract class OpSleight$SwapSpellMixin {
    @Shadow
    public abstract class_1542 getItem();

    @Inject(at = @At("HEAD"), method = "cast")
    public void cast(@NotNull CastingEnvironment env, CallbackInfo ci) {
        class_1542 item = getItem();
        if (NBTHelper.contains(item.method_6983(), IS_IN_CRADLE))
            NBTHelper.remove(item.method_6983(), IS_IN_CRADLE);
        class_2338 cradlePos = ((ItemEntityMinterface)item).getBlockPosOfCradle();
        if (cradlePos == null) return;
        CradleEntity cradle = (CradleEntity)env.getWorld().method_8321(cradlePos);
        if (cradle == null) return;
        cradle.method_5448();
    }
}
