package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;

import com.luxof.lapisworks.blocks.entities.SimpleImpetusEntity;
import com.luxof.lapisworks.init.ModPOIs;
import com.luxof.lapisworks.init.Patterns;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4153.class_4155;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value = PatternIota.class, remap = false)
public abstract class PatternIotaMixin {
    @Unique
    private static class_5321<ActionRegistryEntry> doNothing = null;

    @Unique
    private static boolean triggerSimpleImpeti(
        HexPattern pat,
        boolean isValid,
        CastingEnvironment ctx
    ) {
        if (doNothing == null) {
            doNothing = Patterns.ARCHON_OF_MEANINGLESSNESS;
        }
        class_3218 sw = ctx.getWorld();
        // maffs
        try {
            return sw.method_19494().method_19125(
                any -> any.method_40225(ModPOIs.SIMP_IMPETUS_KEY),
                class_2338.method_49638(ctx.mishapSprayPos()),
                32,
                class_4155.field_18489
            ).filter(poi -> {
                class_2338 pos = poi.method_19141();
                if (!(sw.method_8321(pos) instanceof SimpleImpetusEntity simpleImpetus)) return false;
                return simpleImpetus.tryTrigger(
                    pat.anglesSignature(),
                    isValid,
                    // so it doesn't explode in my face one day
                    ctx.getCastingEntity() instanceof class_3222 sp ? sp : null
                );
            }).count() > 0;
        } catch (Exception e) { // HexDebug
            return false;
        }
    }

    @Shadow
    public abstract HexPattern getPattern();

    @Inject(
        method = "execute",
        at = @At(
            value = "INVOKE_ASSIGN",
            // woah, being able to browse bytecode to just copy-paste is so fucking neat
            target = "at/petrak/hexcasting/common/casting/PatternRegistryManifest.matchPattern(Lat/petrak/hexcasting/api/casting/math/HexPattern;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;Z)Lat/petrak/hexcasting/api/casting/PatternShapeMatch;"
        ),
        locals = LocalCapture.CAPTURE_FAILHARD
    )
    public @NotNull void execute(
        CastingVM vm,
        class_3218 world,
        SpellContinuation continuation,
        CallbackInfoReturnable<CastResult> cir,
        @Local LocalRef<PatternShapeMatch> lookupRef
    ) {
        if (triggerSimpleImpeti(
                getPattern(),
                !(lookupRef.get() instanceof PatternShapeMatch.Nothing),
                vm.getEnv()
            )) {
            lookupRef.set(new PatternShapeMatch.Normal(doNothing));
        }
    }
}
