package com.luxof.lapisworks.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import com.luxof.lapisworks.inv.BrewerInv;

import static com.luxof.lapisworks.Lapisworks.potionEquals;
import static net.minecraft.class_1799.field_8037;

import com.mojang.datafixers.util.Either;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class BrewingRec implements class_1860<BrewerInv> {
    private final class_2960 id;
    private final boolean isItemBrew;

    private final BrewerIngredientWithCount itemFrom;
    private final class_1799 itemOutput;
    private final String potionFrom;
    private final String potionOutput;

    private final List<BrewerIngredientWithCount> input;

    public static class Type implements class_3956<BrewingRec> {
        private Type() {}
        public static final Type INSTANCE = new Type();
    }

    public static class BrewerIngredientWithCount {
        public class_1856 ingredient;
        public int amount;
        protected BrewerIngredientWithCount(class_1856 ing, int am) {
            this.ingredient = ing;
            this.amount = am;
        }
        protected static BrewerIngredientWithCount fromJson(JsonObject json) {
            return new BrewerIngredientWithCount(
                class_1856.method_52177(json),
                class_3518.method_15260(json, "count")
            );
        }

        protected static BrewerIngredientWithCount fromJson(JsonElement json) {
            if (!json.isJsonObject()) throw new JsonSyntaxException("Invalid field in (probably the input field of) the recipe: " + BrewingRecSerializer.currentId.toString());
            return fromJson(json.getAsJsonObject());
        }

        protected void write(class_2540 buf) {
            ingredient.method_8088(buf);
            buf.writeInt(amount);
        }

        protected static void write(class_2540 buf, BrewerIngredientWithCount ing) {
            ing.ingredient.method_8088(buf);
            buf.writeInt(ing.amount);
        }

        protected static BrewerIngredientWithCount read(class_2540 buf) {
            return new BrewerIngredientWithCount(
                class_1856.method_8086(buf),
                buf.readInt()
            );
        }
    }

    public BrewingRec(
        class_2960 id,
        BrewerIngredientWithCount from,
        List<BrewerIngredientWithCount> input,
        class_1799 to
    ) {
        this.id = id;
        this.input = input;
        this.isItemBrew = true;

        this.itemFrom = from;
        this.itemOutput = to;

        this.potionFrom = null;
        this.potionOutput = null;
    }
    public BrewingRec(
        class_2960 id,
        class_2960 from,
        List<BrewerIngredientWithCount> input,
        class_2960 to
    ) {
        this.id = id;
        this.input = input;
        this.isItemBrew = false;

        this.itemFrom = null;
        this.itemOutput = null;

        this.potionFrom = from.toString();
        this.potionOutput = to.toString();
    }

    @Override
    public class_2960 method_8114() { return this.id; }
    /** if yields <code>true</code>, any <code>Either</code>-returning methods you find will only have
     * their left sides present. opposite if not. */
    public boolean isItemBrew() { return this.isItemBrew; }
    public List<BrewerIngredientWithCount> getPossibleInputs() { return this.input; }

    public Either<BrewerIngredientWithCount, String> getFrom() {
        return this.isItemBrew ? Either.left(this.itemFrom) : Either.right(this.potionFrom);
    }
    public Either<class_1799, String> getOutput() {
        return this.isItemBrew ? Either.left(this.itemOutput) : Either.right(this.potionOutput);
    }


    // hmm..
    @Override
    public class_1799 method_8110(class_5455 registryManager) { return class_1799.field_8037.method_7972(); }

    /** provides a separate result for each potion it's brewing into.
     * does not mutate what's coming in.
     * idx=3 to idx=5 tell you what must be ejected.
     * idx=6 stack tells you how much of the input you've got left. */
    public List<class_1799> craft(BrewerInv inv) {

        List<class_1799> brewing = new ArrayList<>(inv.brewingInto);
        List<class_1799> brewed = new ArrayList<>();
        List<class_1799> eject = new ArrayList<>();

        for (class_1799 brew : brewing) {
            if (brew.method_7960()) {
                brewed.add(brew);
                eject.add(field_8037.method_7972());
                continue;
            }
            if (isItemBrew) {
                class_1856 ingredient = itemFrom.ingredient;
                int requiredForOneBatch = itemFrom.amount;
                if (ingredient.method_8093(brew) && brew.method_7947() >= requiredForOneBatch) {
                    brewed.add(this.itemOutput.method_7972());
                    eject.add(brew.method_46651(brew.method_7947() - requiredForOneBatch));
                }

            } else {
                if (potionEquals(potionFrom, brew)) {
                    class_1799 potionOut = brew.method_7972();
                    class_1844.method_8061(potionOut, class_1842.method_8048(potionOutput));
                    brewed.add(potionOut);
                    eject.add(brew.method_46651(brew.method_7947() - 1));

                } else {
                    brewed.add(brew);
                    eject.add(field_8037.method_7972());
                }
            }
        }

        class_1799 inputStack = inv.input;

        for (BrewerIngredientWithCount ing : this.input) {
            if (!(ing.ingredient.method_8093(inputStack) && ing.amount >= inputStack.method_7947())) continue;
            eject.add(inputStack.method_46651(inputStack.method_7947() - ing.amount));
            break;
        }

        brewed.addAll(eject);
        return brewed;
    }

    /** don't use this. */
    @Override
    public class_1799 craft(BrewerInv inventory, class_5455 registryManager) {
        return class_1799.field_8037.method_7972();
    }

    @Override
    public class_1865<?> method_8119() { return BrewingRecSerializer.INSTANCE; }

    @Override
    public boolean matches(BrewerInv inventory, class_1937 world) {
        class_1799 inputStack = inventory.input;

        boolean validInp = this.input.stream()
            .filter(ing -> ing.ingredient.method_8093(inputStack) && inputStack.method_7947() >= ing.amount)
            .count() > 0;

        boolean validBrewingInto = inventory.brewingInto.stream()
            .filter(stack -> isItemBrew ?
                itemFrom.ingredient.method_8093(stack) && stack.method_7947() >= itemFrom.amount
                : potionEquals(stack, potionFrom)
            )
            .count() > 0;

        return validInp && validBrewingInto;
    }

    @Override public boolean method_8113(int width, int height) { return true; }
    @Override public class_3956<?> method_17716() { return Type.INSTANCE; }
}
