package com.luxof.lapisworks.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import com.luxof.lapisworks.recipes.BrewingRec.BrewerIngredientWithCount;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class BrewingRecSerializer implements class_1865<BrewingRec> {
    private BrewingRecSerializer() {}
    protected static class_2960 currentId = null;

    public static final BrewingRecSerializer INSTANCE = new BrewingRecSerializer();

    // sorry.
    @Override
    public BrewingRec method_8121(class_2960 id, JsonObject json) {
        currentId = id;
        String brew = class_3518.method_15265(json, "brew");


        List<BrewerIngredientWithCount> input = class_3518.method_15261(json, "input").asList().stream().map(
            BrewerIngredientWithCount::fromJson
        ).toList();


        if (brew.equals("item")) {
            BrewerIngredientWithCount from = BrewerIngredientWithCount.fromJson(
                class_3518.method_15296(json, "from")
            );
            JsonObject toObject = class_3518.method_15296(json, "to");
            class_1799 to = new class_1799(
                class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265(toObject, "item"))),
                class_3518.method_15260(toObject, "count")
            );
            return new BrewingRec(id, from, input, to);


        } else if (brew.equals("potion")) {
            class_2960 from = new class_2960(class_3518.method_15265(json, "from"));
            class_2960 to = new class_2960(class_3518.method_15265(json, "to"));
            return new BrewingRec(id, from, input, to);


        } else {
            throw new JsonSyntaxException("Unknown brew type!: " + brew);
        }
    }

    @Override
    public BrewingRec method_8122(class_2960 id, class_2540 buf) {
        boolean isItemBrew = buf.readBoolean();
        // :rolling_eyes:
        /*return new BrewingRec(
            id,
            isItemBrew ? BrewerIngredientWithCount.read(buf) : buf.readIdentifier(),
            buf.readList(BrewerIngredientWithCount::read),
            isItemBrew ? buf.readItemStack() : buf.readIdentifier()
        )*/
        return isItemBrew ? new BrewingRec(
            id,
            BrewerIngredientWithCount.read(buf),
            buf.method_34066(BrewerIngredientWithCount::read),
            buf.method_10819()
        ) : new BrewingRec(
            id,
            buf.method_10810(),
            buf.method_34066(BrewerIngredientWithCount::read),
            buf.method_10810()
        );
    }

    @Override
    public void write(class_2540 buf, BrewingRec recipe) {
        List<BrewerIngredientWithCount> inputs = recipe.getPossibleInputs();

        buf.writeBoolean(recipe.isItemBrew());
        if (recipe.isItemBrew()) {
            recipe.getFrom().left().get().write(buf);
            buf.method_34062(inputs, BrewerIngredientWithCount::write);
            buf.method_10793(recipe.getOutput().left().get());
        } else {
            buf.method_10812(new class_2960(recipe.getFrom().right().get()));
            buf.method_34062(inputs, BrewerIngredientWithCount::write);
            buf.method_10812(new class_2960(recipe.getOutput().right().get()));
        }
    }
}
