package com.luxof.lapisworks.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import com.luxof.lapisworks.recipes.ImbuementRec.ImbuementRecJsonFormat;
import com.luxof.lapisworks.recipes.ImbuementRec.ImbuementRecModJsonFormat;

import static com.luxof.lapisworks.Lapisworks.verDifference;

import java.util.List;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ImbuementRecSerializer implements class_1865<ImbuementRec> {
    private ImbuementRecSerializer() {}
    public static final ImbuementRecSerializer INSTANCE = new ImbuementRecSerializer();

    private static boolean modsLoaded(class_2960 recipeId, List<JsonObject> mods) {
        for (JsonObject obj : mods) {
            ImbuementRecModJsonFormat mod = new Gson().fromJson(obj, ImbuementRecModJsonFormat.class);
            if (!FabricLoader.getInstance().isModLoaded(mod.id)) return false;
            if (mod.min == null) continue;
            Integer diff = verDifference(mod.id, mod.min);
            if (diff == null) throw new JsonSyntaxException("Invalid version (" + mod.min + ") for mod \"" + mod.id + "\" in recipe " + recipeId.toString());
            else if (diff < 0) return false;
        }
        return true;
    }

    @Override
    public ImbuementRec method_8121(class_2960 id, JsonObject json) {
        ImbuementRecJsonFormat recipeJson = new Gson().fromJson(json, ImbuementRecJsonFormat.class);
        if (recipeJson.normal == null) {
            throw new JsonSyntaxException("Specify a motherfuckin' start, cuh. (" + id + ")");
        } else if (recipeJson.fullamel == null) {
            throw new JsonSyntaxException("The journey may not always be about the destination, but this ain't no journey. Specify a fullamel. (" + id + ")");
        } else if (recipeJson.cost == null) {
            throw new JsonSyntaxException("You didn't specify a cost. (" + id + ")");
        }
        if (recipeJson.requiredmod != null &&
            !modsLoaded(id, recipeJson.requiredmod)) {
            return new ImbuementRec(
                id,
                false,
                class_1856.method_8091(class_1802.field_8162),
                class_1802.field_8162,
                class_1802.field_8162,
                0
            );
        }
        class_1856 normal = class_1856.method_52177(recipeJson.normal);
        class_1792 partAmel;
        try {
            partAmel = class_7923.field_41178.method_17966(new class_2960(recipeJson.partamel)).orElseGet(() -> null);
        } catch (NullPointerException e) { partAmel = null; }
        class_1792 fullAmel = class_7923.field_41178.method_17966(new class_2960(recipeJson.fullamel))
            .orElseThrow(() -> new JsonSyntaxException("No such item (fullamel): " + recipeJson.fullamel));

        return new ImbuementRec(id, true, normal, partAmel, fullAmel, recipeJson.cost);
    }

    @Override
    public ImbuementRec method_8122(class_2960 id, class_2540 buf) {
        return new ImbuementRec(
            id,
            buf.readBoolean(),
            class_1856.method_8086(buf),
            buf.readBoolean() ? class_7923.field_41178.method_10223(buf.method_10810()) : null,
            class_7923.field_41178.method_10223(buf.method_10810()),
            buf.readInt()
        );
    }

    @Override
    public void write(class_2540 buf, ImbuementRec recipe) {
        buf.writeBoolean(recipe.getRequiredModIsLoaded());
        recipe.getNormal().method_8088(buf);
        buf.writeBoolean(recipe.getPartAmel() != null);
        if (recipe.getPartAmel() != null) {
            buf.method_10812(class_7923.field_41178.method_10221(recipe.getPartAmel()));
        }
        buf.method_10812(class_7923.field_41178.method_10221(recipe.getFullAmel()));
        buf.writeInt(recipe.getFullAmelsCost());
    }
}
