package com.luxof.lapisworks.recipes;

import com.google.gson.JsonObject;

import com.luxof.lapisworks.inv.HandsInv;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class MoldRec implements class_1860<HandsInv> {
    private final class_2960 id;
    private final class_1856 input;
    private final class_1792 output;
    private final boolean enabled;

    public static class Type implements class_3956<MoldRec> {
        private Type() {}
        public static final Type INSTANCE = new Type();
    }
    
    protected class MoldRecJsonFormat {
        List<String> requiredmod;
        JsonObject input;
        String output;
    }

    public MoldRec(
        class_2960 id,
        class_1856 input,
        class_1792 output,
        boolean enabled
    ) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.enabled = enabled;
    }

    @Override
    public class_2960 method_8114() { return this.id; }
    /** Only returns false when this recipe has been disabled due to required mod(s) not being present. */
    public boolean getEnabled() { return this.enabled; }
    public class_1856 getInput() { return this.input; }
    public class_1792 getOutput() { return this.output; }
    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        return new class_1799(this.getOutput());
    }

    @Override
    public class_1799 craft(HandsInv inventory, class_5455 registryManager) {
        return this.method_8110(registryManager).method_7972();
    }

    @Override
    public boolean matches(HandsInv inventory, class_1937 world) {
        return this.enabled ?
            inventory.getHands().stream().map(stack -> this.input.method_8093(stack)).toList().contains(true)
            : false;
    }

    @Override public boolean method_8113(int width, int height) { return true; }
    @Override public class_1865<?> method_8119() { return MoldRecSerializer.INSTANCE; }
    @Override public class_3956<?> method_17716() { return Type.INSTANCE; }
}
