/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.blocks.entities;

import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.blocks.MediaCondenser;
import com.luxof.lapisworks.blocks.stuff.LinkableMediaBlock;
import com.luxof.lapisworks.init.ModBlocks;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MediaCondenserEntity
extends class_2586
implements LinkableMediaBlock {
    public long media = 0L;
    public long mediaCap = 640000L;
    public HashSet<class_2338> linkedCondensers = new HashSet();

    public MediaCondenserEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MEDIA_CONDENSER_ENTITY_TYPE, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        int filledState;
        if (world.field_9236) {
            return;
        }
        class_3218 sw = (class_3218)world;
        try {
            filledState = Math.min(14, (int)Math.floor((double)this.media / ((double)this.mediaCap / 15.0)));
        }
        catch (ArithmeticException e) {
            return;
        }
        if (filledState == (Integer)state.method_11654((class_2769)MediaCondenser.FILLED)) {
            return;
        }
        sw.method_8501(pos, (class_2680)state.method_11657((class_2769)MediaCondenser.FILLED, (Comparable)Integer.valueOf(filledState)));
    }

    private List<Integer> posToInts(HashSet<class_2338> posList) {
        return posList.stream().flatMap(pos -> Stream.of(pos.method_10263(), pos.method_10264(), pos.method_10260())).toList();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("media", this.media);
        nbt.method_10544("max", this.mediaCap);
        nbt.method_10572("links", this.posToInts(this.linkedCondensers));
    }

    private HashSet<class_2338> intsToPos(int[] intArray) {
        HashSet<class_2338> posList = new HashSet<class_2338>();
        int x = 0;
        int y = 0;
        int part = 0;
        for (int integer : intArray) {
            switch (part) {
                case 0: {
                    x = integer;
                    break;
                }
                case 1: {
                    y = integer;
                    break;
                }
                case 2: {
                    posList.add(new class_2338(x, y, integer));
                    break;
                }
            }
            part = (part + 1) % 3;
        }
        return posList;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.media = nbt.method_10537("media");
        this.mediaCap = nbt.method_10537("max");
        this.linkedCondensers = this.intsToPos(nbt.method_10561("links"));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void addLink(class_2338 pos) {
        this.linkedCondensers.add(pos);
    }

    @Override
    public void removeLink(class_2338 pos) {
        this.linkedCondensers.remove(pos);
    }

    @Override
    public boolean isLinkedTo(class_2338 pos) {
        return this.linkedCondensers.contains(pos);
    }

    @Override
    public Set<class_2338> getLinks() {
        return this.linkedCondensers;
    }

    @Override
    public int getNumberOfLinks() {
        return this.linkedCondensers.size();
    }

    @Override
    public class_2338 getThisPos() {
        return this.method_11016();
    }

    @Override
    public long depositMedia(long amount, boolean simulate) {
        long prevMedia = this.media;
        long nowMedia = Math.min(this.media + amount, this.mediaCap);
        if (!simulate) {
            this.media = nowMedia;
            this.method_5431();
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 2);
        }
        return nowMedia - prevMedia;
    }

    @Override
    public long withdrawMedia(long amount, boolean simulate) {
        long prevMedia = this.media;
        long nowMedia = Math.max(this.media - amount, 0L);
        Lapisworks.LOGGER.info("withdrawal request of " + amount + "! " + (prevMedia - nowMedia) + " left!");
        if (!simulate) {
            this.media = nowMedia;
            this.method_5431();
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 2);
        }
        return prevMedia - nowMedia;
    }
}

