/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.blocks.entities;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.mixinsupport.ControlCircleTickSpeed;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SimpleImpetusEntity
extends BlockEntityAbstractImpetus {
    private String angSig = "";
    private boolean tuned = false;
    private UUID plr = null;
    public static final String TAG_TUNED_PAT = "tuned_pattern";
    public static final String TAG_IS_TUNED = "tuned";
    public static final String TAG_PLAYER = "player";

    public SimpleImpetusEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(ModBlocks.SIMPLE_IMPETUS_ENTITY_TYPE, pWorldPosition, pBlockState);
    }

    public void startExecution(@Nullable class_3222 sp) {
        super.startExecution(this.getPlayer());
        if (this.executionState == null) {
            return;
        }
        ((ControlCircleTickSpeed)this.executionState).setForcedTPT(4);
        CastingImage img = this.executionState.currentImage;
        this.executionState.currentImage.copy(List.of(new EntityIota((class_1297)sp)), img.getParenCount(), img.getParenthesized(), img.getEscapeNext(), img.getOpsConsumed(), img.getUserData());
    }

    protected void saveModData(class_2487 nbt) {
        super.saveModData(nbt);
        nbt.method_10582(TAG_TUNED_PAT, this.angSig);
        nbt.method_10556(TAG_IS_TUNED, this.tuned);
        if (this.plr != null) {
            nbt.method_25927(TAG_PLAYER, this.plr);
        } else {
            Lapisworks.LOGGER.warn("Player was null in a Simple Impetus. Don't do that!");
        }
    }

    protected void loadModData(class_2487 nbt) {
        super.loadModData(nbt);
        this.angSig = nbt.method_10558(TAG_TUNED_PAT);
        this.tuned = nbt.method_10577(TAG_IS_TUNED);
        if (nbt.method_10545(TAG_PLAYER)) {
            this.plr = nbt.method_25926(TAG_PLAYER);
        } else {
            Lapisworks.LOGGER.warn("Player was null in a Simple Impetus. Don't do that!");
        }
    }

    public boolean tryTrigger(String pat, boolean isValidPat, @Nullable class_3222 sp) {
        if (!this.tuned && isValidPat || this.angSig.equals(pat)) {
            this.startExecution(sp);
        }
        return this.tuned && this.angSig.equals(pat);
    }

    public void tune(String pat, boolean tuneOrNot) {
        this.tuned = tuneOrNot;
        this.angSig = tuneOrNot ? pat : "";
    }

    public String getTuned() {
        return this.angSig;
    }

    public boolean getIsTuned() {
        return this.tuned;
    }

    @Nullable
    public class_3222 getPlayer() {
        if (this.plr == null) {
            return null;
        }
        return (class_3222)this.field_11863.method_18470(this.plr);
    }

    public void setPlayer(class_3222 sp) {
        this.plr = sp.method_5667();
    }
}

