/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.blocks.stuff;

import com.luxof.lapisworks.inv.BrewerInv;
import com.luxof.lapisworks.recipes.BrewingRec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBrewerEntity
extends class_2586
implements class_3908,
class_1263 {
    public int fuel = 0;
    public int brewTime = -1;
    public final int maxFuel;
    public final int maxBrewTime;
    protected List<BrewingRec> currentRecipes = new ArrayList<BrewingRec>();
    public BrewerInv inv = new BrewerInv(class_1799.field_8037.method_7972(), class_1799.field_8037.method_7972(), List.of(class_1799.field_8037.method_7972(), class_1799.field_8037.method_7972(), class_1799.field_8037.method_7972()));

    public AbstractBrewerEntity(class_2591<?> type, class_2338 pos, class_2680 state, int maxFuel, int maxBrewTime) {
        super(type, pos, state);
        this.maxFuel = maxFuel;
        this.maxBrewTime = maxBrewTime;
    }

    public AbstractBrewerEntity(class_2591<?> type, class_2338 pos, class_2680 state, int maxFuel, int maxBrewTime, BrewerInv inv) {
        this(type, pos, state, maxFuel, maxBrewTime);
        this.inv = inv;
    }

    protected void attemptRefuel() {
        if (this.currentRecipes.size() <= 0) {
            return;
        }
        if (this.fuel == 0) {
            if (this.inv.blaze.method_7960() || this.inv.blaze.method_7947() <= 0) {
                return;
            }
            this.inv.blaze.method_7934(1);
            this.fuel = this.maxFuel;
            this.method_5431();
        }
        if (this.brewTime <= 0 && this.fuel > 0) {
            --this.fuel;
            this.brewTime = this.maxBrewTime;
            this.method_5431();
        }
    }

    protected List<BrewingRec> updateRecipes(BrewerInv inv) {
        return new ArrayList<BrewingRec>(this.field_11863.method_8433().method_17877((class_3956)BrewingRec.Type.INSTANCE, (class_1263)inv, this.field_11863));
    }

    protected void craft(BrewingRec recipe, BrewerInv inv) {
        List<class_1799> crafted = recipe.craft(inv);
        inv.brewingInto = new ArrayList<class_1799>(crafted.subList(0, 3));
        try {
            inv.input = crafted.get(6);
        }
        catch (Exception e) {
            return;
        }
        for (class_1799 stack : crafted.subList(3, 6)) {
            if (stack.method_7960()) continue;
            class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), stack);
            this.field_11863.method_8649((class_1297)item);
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.brewTime == 0) {
            if (this.fuel > 0) {
                --this.fuel;
                this.brewTime = this.maxBrewTime;
            }
            for (BrewingRec recipe : this.currentRecipes) {
                this.craft(recipe, this.inv);
            }
            this.currentRecipes.clear();
        }
        this.attemptRefuel();
        this.currentRecipes = this.updateRecipes(this.inv);
        if (this.currentRecipes.size() == 0) {
            return;
        }
        if (this.brewTime >= 0) {
            --this.brewTime;
        }
        this.method_5431();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.inv.writeNbt(nbt);
        nbt.method_10569("fuel", this.fuel);
        nbt.method_10569("brewTime", this.brewTime);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inv.readNbt(nbt);
        this.fuel = nbt.method_10550("fuel");
        this.brewTime = nbt.method_10550("brewTime");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_5448() {
        this.inv.method_5448();
    }

    public boolean method_5443(class_1657 player) {
        return this.inv.method_5443(player);
    }

    public class_1799 method_5438(int slot) {
        return this.inv.method_5438(slot);
    }

    public boolean method_5442() {
        return this.inv.method_5442();
    }

    public class_1799 method_5441(int slot) {
        return this.inv.method_5441(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inv.method_5434(slot, amount);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inv.method_5447(slot, stack);
    }

    public int method_5439() {
        return this.inv.method_5439();
    }
}

