/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.client.screens;

import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.client.screens.EnchBrewerScreenHandler;
import com.luxof.lapisworks.recipes.BrewingRec;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class EnchBrewerScreen
extends class_465<EnchBrewerScreenHandler> {
    private static final class_2960 TEXTURE = Lapisworks.id("textures/gui/brewer/enchanted.png");

    public EnchBrewerScreen(EnchBrewerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    private void drawIsBrewing(class_332 context, int x, int y) {
        int isBrewingIconX = x + 102;
        int isBrewingIconY = y + 30;
        int yesBrewingIconX = 176;
        int yesBrewingIconY = 10;
        context.method_25302(TEXTURE, isBrewingIconX, isBrewingIconY, yesBrewingIconX, yesBrewingIconY, 18, 18);
    }

    private void drawFuelRod(class_332 ctx, int x, int y) {
        int fuel = ((EnchBrewerScreenHandler)this.field_2797).getFuel();
        int rodHeight = 10;
        int filledHeight = fuel;
        int rodX = x + 79;
        int rodY = y + 34 + (rodHeight - filledHeight);
        int rodU = 176;
        int rodV = rodHeight - filledHeight;
        ctx.method_25302(TEXTURE, rodX, rodY, rodU, rodV, 3, filledHeight);
    }

    private void drawBrewTimeRod(class_332 ctx, int x, int y) {
        int brewTime = ((EnchBrewerScreenHandler)this.field_2797).getBrewTime();
        if (brewTime <= 0) {
            return;
        }
        int rodHeight = 10;
        int maxBrewTime = 200;
        int filledHeight = brewTime * (rodHeight / maxBrewTime);
        int rodX = x + 92;
        int rodY = y + 34 + (rodHeight - filledHeight);
        int rodU = 179;
        int rodV = rodHeight - filledHeight;
        ctx.method_25302(TEXTURE, rodX, rodY, rodU, rodV, 3, filledHeight);
    }

    private void drawBrewingRods(class_332 ctx, int x, int y) {
        List<BrewingRec> recipes = ((EnchBrewerScreenHandler)this.field_2797).getRecipes();
        List brewingInto = ((EnchBrewerScreenHandler)this.field_2797).inventory.brewingInto;
        this.drawBrewingRod(ctx, x + 73, y + 57, 5, 3, (class_1799)brewingInto.get(0), recipes);
        this.drawBrewingRod(ctx, x + 86, y + 62, 3, 1, (class_1799)brewingInto.get(1), recipes);
        this.drawBrewingRod(ctx, x + 96, y + 57, 5, 3, (class_1799)brewingInto.get(2), recipes);
    }

    private void drawBrewingRod(class_332 ctx, int rodX, int rodY, int width, int height, class_1799 stack, List<BrewingRec> recipes) {
        for (BrewingRec recipe : recipes) {
            if (recipe.isItemBrew()) {
                if (!((BrewingRec.BrewerIngredientWithCount)recipe.getFrom().left().get()).ingredient.method_8093(stack)) continue;
                this.drawOnBrewingRod(ctx, rodX, rodY, width, height, class_1844.method_8064((class_1799)((class_1799)recipe.getOutput().left().get())));
                break;
            }
            class_1842 fromPotion = class_1842.method_8048((String)((String)recipe.getFrom().right().get()));
            if (class_1844.method_8063((class_1799)stack) != fromPotion) continue;
            this.drawOnBrewingRod(ctx, rodX, rodY, width, height, class_1844.method_8062((class_1842)class_1842.method_8048((String)((String)recipe.getOutput().right().get()))));
            break;
        }
    }

    private int darken(int color) {
        int R = color & 0xFF;
        int G = color & 0xFF00;
        int B = color & 0xFF0000;
        return Math.max(R - 68, 0) + Math.max(G - 17408, 0) + Math.max(B - 0x440000, 0);
    }

    private void drawOnBrewingRod(class_332 ctx, int rodX, int rodY, int width, int height, int color) {
        int border = this.darken(color);
        if (width > height) {
            ctx.method_25292(rodX, rodX + width, rodY, border);
            ctx.method_25292(rodX, rodX + width, rodY + height - 1, border);
            for (int y = rodY; y < rodY + height - 1; ++y) {
                ctx.method_25301(rodX, rodX + width, y, color);
            }
        } else {
            ctx.method_25301(rodX, rodY, rodY + height, border);
            ctx.method_25301(rodX + width - 1, rodY, rodY + height, border);
            for (int x = rodX; x < rodX + width - 1; ++x) {
                ctx.method_25301(x, rodY, rodY + height, color);
            }
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
        if (((EnchBrewerScreenHandler)this.field_2797).getIsBrewing()) {
            this.drawIsBrewing(context, x, y);
            this.drawBrewingRods(context, x, y);
        }
        this.drawFuelRod(context, x, y);
        this.drawBrewTimeRod(context, x, y);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
    }
}

