/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.interop.hextended.items.AmelOrb;
import com.luxof.lapisworks.mixinsupport.EnchSentInterface;
import com.luxof.lapisworks.mixinsupport.GetVAULT;
import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements GetVAULT {
    private final VAULT vault = VAULT.of((class_3222)this);

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public VAULT grabVAULT() {
        return this.vault;
    }

    @Inject(at={@At(value="HEAD")}, method={"readCustomDataFromNbt"})
    public void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        try {
            if (nbt.method_10577("LAPISWORKS_EnchSent_exists")) {
                class_243 sentPos = new class_243(nbt.method_10574("LAPISWORKS_EnchSent_posX"), nbt.method_10574("LAPISWORKS_EnchSent_posY"), nbt.method_10574("LAPISWORKS_EnchSent_posZ"));
                double sentAmbit = nbt.method_10574("LAPISWORKS_EnchSent_Ambit");
                ((EnchSentInterface)((Object)this)).setEnchantedSentinel(sentPos, sentAmbit);
            }
        }
        catch (Exception e) {
            Lapisworks.LOGGER.warn("Couldn't load enchanted sentinel!");
            e.printStackTrace();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeCustomDataToNbt"})
    public void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        class_243 sentPos = ((EnchSentInterface)((Object)this)).getEnchantedSentinel();
        Double ambit = ((EnchSentInterface)((Object)this)).getEnchantedSentinelAmbit();
        nbt.method_10556("LAPISWORKS_EnchSent_exists", sentPos != null);
        if (sentPos == null) {
            return;
        }
        nbt.method_10549("LAPISWORKS_EnchSent_posX", sentPos.field_1352);
        nbt.method_10549("LAPISWORKS_EnchSent_posY", sentPos.field_1351);
        nbt.method_10549("LAPISWORKS_EnchSent_posZ", sentPos.field_1350);
        nbt.method_10549("LAPISWORKS_EnchSent_Ambit", ambit.doubleValue());
    }

    public void spawnEnchSentParticles() {
        class_243 sentinelPosition = ((EnchSentInterface)((Object)this)).getEnchantedSentinel();
        if (sentinelPosition == null) {
            return;
        }
        ParticleSpray.burst((class_243)sentinelPosition, (double)2.0, (int)1).sprayParticles((class_3218)this.method_37908(), IXplatAbstractions.INSTANCE.getPigment((class_1657)this));
    }

    public void spawnOrbParticles() {
        List<class_1268> hands = Lapisworks.getAllHands();
        for (class_1268 hand : hands) {
            class_1799 stack = this.method_5998(hand);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof AmelOrb)) continue;
            AmelOrb orb = (AmelOrb)class_17922;
            class_243 placeInAmbit = orb.getPlaceInAmbit(stack);
            ParticleSpray particles = ParticleSpray.burst((class_243)placeInAmbit, (double)3.0, (int)2);
            particles.sprayParticles((class_3218)this.method_37908(), IXplatAbstractions.INSTANCE.getPigment((class_1657)this));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        this.spawnEnchSentParticles();
        this.spawnOrbParticles();
    }
}

