/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.luxof.lapisworks.Lapisworks;
import com.luxof.lapisworks.inv.BrewerInv;
import com.luxof.lapisworks.recipes.BrewingRecSerializer;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class BrewingRec
implements class_1860<BrewerInv> {
    private final class_2960 id;
    private final boolean isItemBrew;
    private final BrewerIngredientWithCount itemFrom;
    private final class_1799 itemOutput;
    private final String potionFrom;
    private final String potionOutput;
    private final List<BrewerIngredientWithCount> input;

    public BrewingRec(class_2960 id, BrewerIngredientWithCount from, List<BrewerIngredientWithCount> input, class_1799 to) {
        this.id = id;
        this.input = input;
        this.isItemBrew = true;
        this.itemFrom = from;
        this.itemOutput = to;
        this.potionFrom = null;
        this.potionOutput = null;
    }

    public BrewingRec(class_2960 id, class_2960 from, List<BrewerIngredientWithCount> input, class_2960 to) {
        this.id = id;
        this.input = input;
        this.isItemBrew = false;
        this.itemFrom = null;
        this.itemOutput = null;
        this.potionFrom = from.toString();
        this.potionOutput = to.toString();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean isItemBrew() {
        return this.isItemBrew;
    }

    public List<BrewerIngredientWithCount> getPossibleInputs() {
        return this.input;
    }

    public Either<BrewerIngredientWithCount, String> getFrom() {
        return this.isItemBrew ? Either.left((Object)this.itemFrom) : Either.right((Object)this.potionFrom);
    }

    public Either<class_1799, String> getOutput() {
        return this.isItemBrew ? Either.left((Object)this.itemOutput) : Either.right((Object)this.potionOutput);
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return class_1799.field_8037.method_7972();
    }

    public List<class_1799> craft(BrewerInv inv) {
        ArrayList<class_1799> brewing = new ArrayList<class_1799>(inv.brewingInto);
        ArrayList<class_1799> brewed = new ArrayList<class_1799>();
        ArrayList<class_1799> eject = new ArrayList<class_1799>();
        for (class_1799 brew : brewing) {
            if (brew.method_7960()) {
                brewed.add(brew);
                eject.add(class_1799.field_8037.method_7972());
                continue;
            }
            if (this.isItemBrew) {
                class_1856 ingredient = this.itemFrom.ingredient;
                int requiredForOneBatch = this.itemFrom.amount;
                if (!ingredient.method_8093(brew) || brew.method_7947() < requiredForOneBatch) continue;
                brewed.add(this.itemOutput.method_7972());
                eject.add(brew.method_46651(brew.method_7947() - requiredForOneBatch));
                continue;
            }
            if (Lapisworks.potionEquals(this.potionFrom, brew)) {
                class_1799 potionOut = brew.method_7972();
                class_1844.method_8061((class_1799)potionOut, (class_1842)class_1842.method_8048((String)this.potionOutput));
                brewed.add(potionOut);
                eject.add(brew.method_46651(brew.method_7947() - 1));
                continue;
            }
            brewed.add(brew);
            eject.add(class_1799.field_8037.method_7972());
        }
        class_1799 inputStack = inv.input;
        for (BrewerIngredientWithCount ing : this.input) {
            if (!ing.ingredient.method_8093(inputStack) || ing.amount < inputStack.method_7947()) continue;
            eject.add(inputStack.method_46651(inputStack.method_7947() - ing.amount));
            break;
        }
        brewed.addAll(eject);
        return brewed;
    }

    public class_1799 craft(BrewerInv inventory, class_5455 registryManager) {
        return class_1799.field_8037.method_7972();
    }

    public class_1865<?> method_8119() {
        return BrewingRecSerializer.INSTANCE;
    }

    public boolean matches(BrewerInv inventory, class_1937 world) {
        class_1799 inputStack = inventory.input;
        boolean validInp = this.input.stream().filter(ing -> ing.ingredient.method_8093(inputStack) && inputStack.method_7947() >= ing.amount).count() > 0L;
        boolean validBrewingInto = inventory.brewingInto.stream().filter(stack -> this.isItemBrew ? this.itemFrom.ingredient.method_8093(stack) && stack.method_7947() >= this.itemFrom.amount : Lapisworks.potionEquals(stack, this.potionFrom)).count() > 0L;
        return validInp && validBrewingInto;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static class BrewerIngredientWithCount {
        public class_1856 ingredient;
        public int amount;

        protected BrewerIngredientWithCount(class_1856 ing, int am) {
            this.ingredient = ing;
            this.amount = am;
        }

        protected static BrewerIngredientWithCount fromJson(JsonObject json) {
            return new BrewerIngredientWithCount(class_1856.method_52177((JsonElement)json), class_3518.method_15260((JsonObject)json, (String)"count"));
        }

        protected static BrewerIngredientWithCount fromJson(JsonElement json) {
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("Invalid field in (probably the input field of) the recipe: " + BrewingRecSerializer.currentId.toString());
            }
            return BrewerIngredientWithCount.fromJson(json.getAsJsonObject());
        }

        protected void write(class_2540 buf) {
            this.ingredient.method_8088(buf);
            buf.writeInt(this.amount);
        }

        protected static void write(class_2540 buf, BrewerIngredientWithCount ing) {
            ing.ingredient.method_8088(buf);
            buf.writeInt(ing.amount);
        }

        protected static BrewerIngredientWithCount read(class_2540 buf) {
            return new BrewerIngredientWithCount(class_1856.method_8086((class_2540)buf), buf.readInt());
        }
    }

    public static class Type
    implements class_3956<BrewingRec> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

