package com.luxof.lapisworks.BeegInfusions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.misc.MediaConstants;
import at.petrak.hexcasting.common.items.ItemStaff;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.init.Mutables.BeegInfusion;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.interop.hextended.LapixtendedInterface;
import com.luxof.lapisworks.items.shit.DurabilityPartAmel;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

import static com.luxof.lapisworks.LapisworksIDs.AMEL;
import static com.luxof.lapisworks.Lapisworks.LOGGER;

public class MakeGenericPartAmel extends BeegInfusion {
    private class_1799 stack = null;
    private class_1792 item = null;
    private class_1268 hand = null;
    private int fullInfusionCost = 0;
    private int infusing = 0;

    @Override
    public boolean test() {
        boolean ret = false;
        for (HeldItemInfo heldInfo : this.heldInfos) {
            stack = heldInfo.stack();
            item = stack.method_7909();
            hand = heldInfo.hand();
            LOGGER.info("Hand: " + hand.toString());
            if (item instanceof ItemStaff) {
                ret = true;
                break;
            }
        }
        fullInfusionCost = item instanceof DurabilityPartAmel durab ?
            stack.method_7936() / durab.getAmelWorthInDurability()
            : Mutables.getBaseCostForInfusionOf(
                LapixtendedInterface.getAppropriateFullAmel(item)
            );
        infusing = Math.min(
            OperatorUtils.getPositiveInt(hexStack, 0, hexStack.size()),
            fullInfusionCost
        );
        LOGGER.info("full vs infusing: " + fullInfusionCost + " " + infusing);
        return ret;
    }

    @Override
    public void mishapIfNeeded() {
        int availableAmel = vault.fetch(Mutables::isAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);
        if (availableAmel < infusing) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughItems(
                AMEL,
                availableAmel,
                infusing
            ));
        }
    }

    @Override
    public Long getCost() { return MediaConstants.SHARD_UNIT * 2 * infusing; }

    @Override
    public void accept() {
        vault.drain(Mutables::isAmel, infusing, Flags.PRESET_Stacks_InvItem_UpToHotbar);

        DurabilityPartAmel partAmel = (DurabilityPartAmel)LapixtendedInterface.getAppropriatePartAmelGeneric(item);
        class_1792 fullAmel = LapixtendedInterface.getAppropriateFullAmel(item);
        class_1799 newStaff;
        if (infusing == fullInfusionCost) { newStaff = new class_1799(fullAmel); }
        else if (!(item instanceof DurabilityPartAmel)) {
            newStaff = new class_1799((class_1792)partAmel);
            newStaff.method_7974(
                newStaff.method_7936() - infusing * partAmel.getAmelWorthInDurability()
            );
        } else {
            newStaff = stack.method_7972();
            newStaff.method_7974(
                stack.method_7919() - infusing * partAmel.getAmelWorthInDurability()
            );
        }
        ctx.replaceItem(
            stack -> stack.method_7909() instanceof ItemStaff, 
            newStaff,
            hand
        );
    }
}
