package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.VAULT.VAULT;
import com.luxof.lapisworks.init.Mutables.BeegInfusion;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.items.shit.BasePartAmel;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import com.luxof.lapisworks.mixinsupport.GetStacks;
import com.luxof.lapisworks.mixinsupport.GetVAULT;
import com.luxof.lapisworks.recipes.HandsInv;
import com.luxof.lapisworks.recipes.ImbuementRec;

import static com.luxof.lapisworks.Lapisworks.getInfusedAmel;
import static com.luxof.lapisworks.Lapisworks.hasInfusedAmel;
import static com.luxof.lapisworks.Lapisworks.setInfusedAmel;
import static com.luxof.lapisworks.LapisworksIDs.AMEL;
import static com.luxof.lapisworks.LapisworksIDs.IMBUEABLE;
import static com.luxof.lapisworks.init.Mutables.Mutables.testBeegInfusionFilters;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

// someone one called this code "unreadable"
// i agree 75%
public class ImbueAmel implements SpellAction {
    public int getArgc() {
        return 1;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        int wantToInfuseAmount = OperatorUtils.getPositiveInt(args, 0, getArgc());
        if (wantToInfuseAmount <= 0) {
            // go fuck yourself
            return new SpellAction.Result(
                new DoNothingSpell(),
                0L,
                List.of(),
                1
            );
        }

        VAULT vault = ((GetVAULT)ctx).grabVAULT();

        int availableAmel = vault.fetch(Mutables::isAmel, Flags.PRESET_Stacks_InvItem_UpToHotbar);
        List<HeldItemInfo> heldInfos = ((GetStacks)ctx).getHeldStacksOtherFirst();
        List<class_1799> heldStacks = ((GetStacks)ctx).getHeldItemStacksOtherFirst();

        MishapBadOffhandItem needImbueable = new MishapBadOffhandItem(
            class_1799.field_8037.method_7972(),
            IMBUEABLE
        );

        Optional<ImbuementRec> recipeOpt = ctx.getWorld().method_8433().method_8132(
            ImbuementRec.Type.INSTANCE,
            new HandsInv(heldStacks),
            ctx.getWorld()
        );
        if (recipeOpt.isEmpty()) {
            // if no recipe, must test BeegInfusions which are lower prio
            Map<class_2960, BeegInfusion> beegInfusionRecipes = testBeegInfusionFilters(
                heldInfos,
                ctx,
                args,
                vault
            );
            if (beegInfusionRecipes.isEmpty()) MishapThrowerJava.throwMishap(needImbueable);

            BeegInfusion selected = beegInfusionRecipes.values().iterator().next();
            selected.mishapIfNeeded();

            return new SpellAction.Result(
                new SpellBeegInfusion(selected),
                selected.getCost(),
                List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 1, 10)),
                1
            );
        }
        ImbuementRec recipe = recipeOpt.get();
        class_1799 items = null;
        class_1268 hand = null;
        for (HeldItemInfo held : heldInfos) {
            if (recipe.getNormal().method_8093(held.stack()) || held.stack().method_31574(recipe.getPartAmel())) {
                items = held.stack();
                hand = held.hand();
            }
        }

        class_1792 partAmel = recipe.getPartAmel();
        class_1792 fullAmel = recipe.getFullAmel();

        int fullInfuseCost = recipe.getFullAmelsCost() - getInfusedAmel(items);
        int infuseAmount = Math.min(wantToInfuseAmount, fullInfuseCost);

        if (availableAmel < infuseAmount) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughItems(AMEL, availableAmel, infuseAmount));
        }

        class_1799 newStack = null;
        if (infuseAmount == fullInfuseCost) { newStack = new class_1799(fullAmel); }
        else if (partAmel == null) {
            MishapThrowerJava.throwMishap(
                new MishapNotEnoughItems(AMEL, infuseAmount, fullInfuseCost)
            );
        } else {
            if (hasInfusedAmel(items)) newStack = items;
            else newStack = new class_1799(partAmel);
            setInfusedAmel(newStack, getInfusedAmel(newStack) + infuseAmount);
            if (newStack.method_7909() instanceof BasePartAmel partAmelI)
                partAmelI.onImbue(newStack, infuseAmount);
        }

        return new SpellAction.Result(
            new Spell(newStack, hand, infuseAmount, vault),
            MediaConstants.DUST_UNIT * 2 * infuseAmount,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 1, 10 + infuseAmount)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1799 changeToItem;
        public final class_1268 hand;
        public final int count;
        public final VAULT vault;

        public Spell(class_1799 changeToItem, class_1268 hand, int count, VAULT vault) {
            this.changeToItem = changeToItem;
            this.hand = hand;
            this.count = count;
            this.vault = vault;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            vault.drain(Mutables::isAmel, count, Flags.PRESET_Stacks_InvItem_UpToHotbar);
            ctx.replaceItem(any -> true, changeToItem, hand);
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    /** really should just call it a sophisticated infusion */
    public class SpellBeegInfusion implements RenderedSpell {
        public final BeegInfusion recipe;

        public SpellBeegInfusion( BeegInfusion recipe ) { this.recipe = recipe; }

        @Override
        public void cast(CastingEnvironment ctx) { this.recipe.accept(); }

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    /** paranoia, ig */
    public class DoNothingSpell implements RenderedSpell {
        @Override
        public void cast(CastingEnvironment arg0) {
            return;
        }

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
