package com.luxof.lapisworks.mishaps;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;

import static com.luxof.lapisworks.LapisworksIDs.NOT_ENOUGH;

import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class MishapNotEnoughItems extends Mishap {
    private final class_2561 itemName;
    private final int required;
    private final int got;

    public MishapNotEnoughItems(class_1799 itemsInOffhand, int requiredAmount) {
        this.itemName = itemsInOffhand.method_7964();
        this.got = itemsInOffhand.method_7947();
        this.required = requiredAmount;
    }
    public MishapNotEnoughItems(class_2561 item, int got, int required) {
        this.itemName = item;
        this.got = got;
        this.required = required;
    }

    @Override
    public FrozenPigment accentColor(CastingEnvironment ctx, Context errorCtx) {
        return dyeColor(class_1767.field_7957);
    }

    @Override
    public void execute(CastingEnvironment env, Context errorCtx, List<Iota> stack) {
        env.getMishapEnvironment().dropHeldItems();
    }

    @Override
    public class_2561 errorMessage(CastingEnvironment ctx, Context errorCtx) {
        return class_2561.method_43469(
            NOT_ENOUGH,
            this.required,
            this.itemName,
            this.got,
            this.itemName
        );
    }
}
