package com.luxof.lapisworks.mixin;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedCastEnv;

import com.luxof.lapisworks.interop.hextended.items.AmelOrb;
import com.luxof.lapisworks.mixinsupport.EnchSentInterface;
import com.luxof.lapisworks.mixinsupport.GetStacks;
import com.luxof.lapisworks.mixinsupport.LapisworksInterface;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value = PlayerBasedCastEnv.class, remap = false)
public abstract class PlayerBasedCastEnvMixin extends CastingEnvironment {
	protected PlayerBasedCastEnvMixin(class_3218 world) { super(world); }

	@Shadow
	public abstract class_1309 getCastingEntity();

	@Inject(at = @At("HEAD"), method = "canOvercast", cancellable = true)
	protected void canOvercast(CallbackInfoReturnable<Boolean> cir) {
		double amountOfMaxHPJuicedUp = ((LapisworksInterface)getCastingEntity())
			.getAmountOfAttrJuicedUpByAmel(class_5134.field_23716);
		if (amountOfMaxHPJuicedUp > 0) {
			cir.setReturnValue(false);
		}
	}

	public boolean isVecInRangeOfEnchSent(class_243 vec) {
		if (this.getCastingEntity() == null) { return false; }
		else if (!(this.getCastingEntity() instanceof class_1657)) { return false; }

		EnchSentInterface player = (EnchSentInterface)this.getCastingEntity();
		class_243 sentPos = player.getEnchantedSentinel();
		Double sentAmbit = player.getEnchantedSentinelAmbit();

		if (sentPos == null) { return false; }
		if (vec.method_1022(sentPos) > sentAmbit) { return false; }

		return true;
	}

	public boolean isVecInRangeOfOrb(class_243 vec) {
		List<HeldItemInfo> heldItems = ((GetStacks)this).getHeldStacks();
		for (HeldItemInfo heldItem : heldItems) {
			if (!(heldItem.stack().method_7909() instanceof AmelOrb orb)) continue;
			class_243 ambitOrigin = orb.getPlaceInAmbit(heldItem.stack());
			if (ambitOrigin == null) continue;
			double ambit = orb.ambitRadius;
			if (vec.method_1022(ambitOrigin) <= ambit) return true;
		}
		return false;
	}

	@Inject(at = @At("HEAD"), method = "isVecInRangeEnvironment", cancellable = true)
	public void isVecInRangeEnvironment(class_243 vec, CallbackInfoReturnable<Boolean> cir) {
		boolean res = isVecInRangeOfEnchSent(vec) || isVecInRangeOfOrb(vec);
		if (res) { cir.setReturnValue(res); }
	}
}
