package com.luxof.lapisworks.mixin;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.luxof.lapisworks.mixinsupport.EnchSentInterface;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;

// "you know you can just use Cardinal Components for this-"
// Metal Gear Rising: Revengeance OST It Has To Be This Way Extended
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements EnchSentInterface {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) { super(entityType, world); }

    public class_243 enchSentPos = null;
    public Double sentRange = null;

    @Override @Nullable public class_243 getEnchantedSentinel() { return this.enchSentPos; }
    @Override @Nullable public Double getEnchantedSentinelAmbit() { return this.sentRange; }
    @Override
    public void setEnchantedSentinel(class_243 pos, Double ambit) {
        this.enchSentPos = pos;
        this.sentRange = ambit;
    }
    @Override
    public boolean shouldBreakSent() {
        return this.getEnchantedSentinel() == null ?
            false :
            this.method_19538().method_1022(this.getEnchantedSentinel()) > 32.0;
    }
    @Override
    public void breakSent() {
        this.setEnchantedSentinel(null, null);
    }

    @Inject(at = @At("HEAD"), method = "tick")
    public void tick(CallbackInfo ci) {
        if (this.shouldBreakSent()) { this.breakSent(); }
    }
}
