package com.luxof.lapisworks.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.misc.MediaConstants;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.TriConsumer;
import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.blocks.entities.MindEntity;
import com.luxof.lapisworks.init.Mutables.Mutables;

import static com.luxof.lapisworks.Lapisworks.toList;
import static com.luxof.lapisworks.LapisworksIDs.FULL_SIMPLE_MIND;
import static com.luxof.lapisworks.LapisworksIDs.IMBUEABLE;
import static com.luxof.lapisworks.LapisworksIDs.MIND_BLOCK;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FlayArtMind implements SpellAction {
    public int getArgc() {
        return 2;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        class_2338 flayIntoPos = OperatorUtils.getBlockPos(args, 0, getArgc());
        Map<class_2960, TriConsumer<class_2338, class_1937, class_3222>> flayers = Mutables.checkImbueMindRecipes(flayIntoPos, ctx.getWorld());
        if (flayers.isEmpty()) {
            MishapThrowerJava.throwMishap(new MishapBadBlock(
                flayIntoPos,
                IMBUEABLE
            ));
        }

        class_2338 mindPos = OperatorUtils.getBlockPos(args, 1, getArgc());
        Mishap needMind = new MishapBadBlock(mindPos, MIND_BLOCK);
        if (!(ctx.getWorld().method_8320(mindPos).method_26204() instanceof Mind) ||
            !(ctx.getWorld().method_8321(mindPos) instanceof MindEntity)) {
            MishapThrowerJava.throwMishap(needMind);
        }
        MindEntity blockEntity = (MindEntity)ctx.getWorld().method_8321(mindPos);
        if (blockEntity.mindCompletion < 100f) {
            MishapThrowerJava.throwMishap(new MishapBadBlock(
                mindPos,
                FULL_SIMPLE_MIND
            ));
        }
        blockEntity.mindCompletion = 0F;

        return new SpellAction.Result(
            new Spell(flayIntoPos, toList(flayers.values()).get(ctx.getWorld().field_9229.method_43048(flayers.size()))),
            MediaConstants.CRYSTAL_UNIT,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 2, 15)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_2338 flayIntoPos;
        public final TriConsumer<class_2338, class_1937, class_3222> flayer;

        public Spell(class_2338 flayIntoPos, TriConsumer<class_2338, class_1937, class_3222> flayer) {
            this.flayIntoPos = flayIntoPos;
            this.flayer = flayer;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            this.flayer.accept(flayIntoPos, ctx.getWorld(), getPlayerOrNull(ctx));
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }

    @Nullable
    public static class_3222 getPlayerOrNull(CastingEnvironment ctx) {
        return ctx.getCastingEntity() != null ? (class_3222)ctx.getCastingEntity() : null;
    }
}
