package com.luxof.lapisworks.actions;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.misc.MediaConstants;
import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.init.Mutables.Mutables;

public class ReclaimAmeth implements SpellAction {
    public int getArgc() {
        return 0;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        HeldItemInfo heldStackInfo = ctx.getHeldItemToOperateOn(Mutables::isAmel);
        if (heldStackInfo == null) {
            MishapThrowerJava.throwMishap(MishapBadOffhandItem.of(class_1799.field_8037.method_7972(), "amel"));
        }
        int count = heldStackInfo.stack().method_7947();

        return new SpellAction.Result(
            new Spell(count * 2, heldStackInfo.hand()),
            MediaConstants.SHARD_UNIT,
            List.of(ParticleSpray.burst(ctx.mishapSprayPos(), 1, 10 + count)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final int count;
        public final class_1268 hand;

        public Spell(int count, class_1268 hand) { this.count = count; this.hand = hand; }

		@Override
		public void cast(CastingEnvironment ctx) {
            ctx.replaceItem(Mutables::isAmel, new class_1799(class_1802.field_27063, Math.min(64, this.count)), hand);
            if (this.count > 64) {
                class_243 spawn = ctx.mishapSprayPos();
                class_1542 ent = new class_1542(
                    ctx.getWorld(),
                    spawn.field_1352,
                    spawn.field_1351,
                    spawn.field_1350,
                    new class_1799(class_1802.field_27063, this.count - 64)
                );
                ctx.getWorld().method_8649(ent);
            }
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
