package com.luxof.lapisworks.actions.great;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment.HeldItemInfo;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.casting.mishaps.MishapUnenlightened;

import com.luxof.lapisworks.MishapThrowerJava;
import com.luxof.lapisworks.init.EnchantCountKeeper;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.mishaps.MishapAlreadyHasEnchantment;
import com.luxof.lapisworks.mishaps.MishapNotEnoughItems;
import com.luxof.lapisworks.mixinsupport.LapisworksInterface;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

/** responsibility of mixin to make enchantment do something falls on the user of this.
 * Also take this' enchantmentIdx if you want the index you need to give to LapisworksInterface's stuff. */
public class GenericEnchant implements SpellAction {
    public final int enchantmentIdx;
    public final int maxLevel;
    public final int requiredAmel;
    public final long requiredMedia;
    public final class_2561 enchantmentLangKey;

    public GenericEnchant(
        int maxLevel,
        int requiredAmel,
        long requiredMedia,
        String enchantmentLangKey
    ) {
        this.enchantmentIdx = EnchantCountKeeper.registerMyEnchantment();
        this.maxLevel = maxLevel;
        this.requiredAmel = requiredAmel;
        this.requiredMedia = requiredMedia;
        this.enchantmentLangKey = class_2561.method_43471(enchantmentLangKey);
    }
    public GenericEnchant(
        int maxLevel,
        int requiredAmel,
        long requiredMedia,
        class_2561 enchantmentLangKey
    ) {
        this.enchantmentIdx = EnchantCountKeeper.registerMyEnchantment();
        this.maxLevel = maxLevel;
        this.requiredAmel = requiredAmel;
        this.requiredMedia = requiredMedia;
        this.enchantmentLangKey = enchantmentLangKey;
    }

    public int getArgc() {
        return 1;
    }

    @Override
    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment ctx) {
        if (!ctx.isEnlightened()) {
            MishapThrowerJava.throwMishap(new MishapUnenlightened());
        }
        class_1309 entity = OperatorUtils.getPlayer(args, 0, getArgc());

        if (((LapisworksInterface)entity).getEnchant(this.enchantmentIdx) >= this.maxLevel) {
            MishapThrowerJava.throwMishap(
                new MishapAlreadyHasEnchantment(
                    entity,
                    this.enchantmentLangKey,
                    this.enchantmentIdx,
                    this.maxLevel
                )
            );
        }

        HeldItemInfo amelInfo = ctx.getHeldItemToOperateOn(Mutables::isAmel);
        if (amelInfo == null) {
            MishapThrowerJava.throwMishap(MishapBadOffhandItem.of(class_1799.field_8037.method_7972(), "amel"));
        } else if (amelInfo.stack().method_7947() < this.requiredAmel) {
            MishapThrowerJava.throwMishap(new MishapNotEnoughItems(amelInfo.stack(), this.requiredAmel));
        }

        return new SpellAction.Result(
            new Spell(entity, amelInfo.stack(), amelInfo.hand()),
            this.requiredMedia,
            List.of(ParticleSpray.burst(entity.method_19538(), 3, 25)),
            1
        );
    }

    public class Spell implements RenderedSpell {
        public final class_1309 entity;
        public final class_1799 stack;
        public final class_1268 hand;

        public Spell(class_1309 entity, class_1799 stack, class_1268 hand) {
            this.entity = entity; this.stack = stack; this.hand = hand;
        }

		@Override
		public void cast(CastingEnvironment ctx) {
            ctx.replaceItem(
                Mutables::isAmel,
                this.stack.method_7947() == requiredAmel ?
                    class_1799.field_8037 :
                    new class_1799(
                        this.stack.method_7909(),
                        this.stack.method_7947() - requiredAmel
                    ),
                 this.hand
            );
            ((LapisworksInterface)this.entity).incrementEnchant(enchantmentIdx);
		}

        @Override
        public CastingImage cast(CastingEnvironment arg0, CastingImage arg1) {
            return RenderedSpell.DefaultImpls.cast(this, arg0, arg1);
        }
    }

    @Override
    public boolean awardsCastingStat(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    public Result executeWithUserdata(List<? extends Iota> args, CastingEnvironment env, class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    public boolean hasCastingSound(CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public OperationResult operate(CastingEnvironment arg0, CastingImage arg1, SpellContinuation arg2) {
        return SpellAction.DefaultImpls.operate(this, arg0, arg1, arg2);
    }
}
