package com.luxof.lapisworks.interop.patchouli;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.interop.patchouli.AbstractPatternComponent;
import at.petrak.hexcasting.xplat.IXplatAbstractions;

import com.google.gson.annotations.SerializedName;

import static com.luxof.lapisworks.init.ThemConfigFlags.chosenFlags;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import vazkii.patchouli.api.IVariable;

public class PerWorldShapePattern extends AbstractPatternComponent {
    @SerializedName("op_id")
    public String opNameRaw;
    public class_2960 opName;

    @Override
    public List<HexPattern> getPatterns(UnaryOperator<IVariable> lookup) {
        class_5321<ActionRegistryEntry> key = class_5321.method_29179(
            IXplatAbstractions.INSTANCE.getActionRegistry().method_30517(),
            new class_2960(
                this.opName.method_12836(),
                this.opName.method_12832() + String.valueOf(chosenFlags.get(this.opName.toString()))
            )
        );
        ActionRegistryEntry entry = IXplatAbstractions.INSTANCE.getActionRegistry().method_29107(key);

        return List.of(entry.prototype());
    }

    @Override public boolean showStrokeOrder() { return true; }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        String opName = lookup.apply(IVariable.wrap(this.opNameRaw)).asString();
        this.opName = class_2960.method_12829(opName);

        super.onVariablesAvailable(lookup);
    }
}
