package com.luxof.lapisworks.items;

import at.petrak.hexcasting.api.utils.NBTHelper;

import com.luxof.lapisworks.VAULT.Flags;
import com.luxof.lapisworks.init.ModItems;
import com.luxof.lapisworks.init.Mutables.Mutables;
import com.luxof.lapisworks.items.shit.InventoryItem;

import static com.luxof.lapisworks.Lapisworks.LOGGER;
import static com.luxof.lapisworks.Lapisworks.getAllHands;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class AmelJar extends class_1792 implements InventoryItem {
    private static final class_1793 defaultSettings = new class_1792.class_1793().method_7889(1);
    public AmelJar(int maxAmel, boolean worksInHotbar) { super(defaultSettings); this.maxAmel = maxAmel; this.worksInHotbar = worksInHotbar; }
    public AmelJar(class_1793 settings, int maxAmel, boolean worksInHotbar) {super(settings); this.maxAmel = maxAmel; this.worksInHotbar = worksInHotbar; }

    private static final String STORED_AMEL = "amel_amount";
    public final int maxAmel;
    public final boolean worksInHotbar;

    public class_1271<class_1799> deposit(
        class_1657 user,
        class_1268 hand,
        class_1799 stack,
        List<class_1268> otherHands
    ) {
        class_1268 amelHand = null;
        class_1799 amelStack = null;
        for (class_1268 selectedHand : otherHands) {
            class_1799 possiblyAmel = user.method_5998(selectedHand);
            if (!Mutables.isAmel(possiblyAmel)) continue;
            amelHand = selectedHand;
            amelStack = possiblyAmel.method_7972();
        }
        if (amelHand == null) return class_1271.method_22431(stack);
        int currentlyStored = this.getStored(stack);
        int currentLimit = this.maxAmel - currentlyStored;
        int amelWillBeLeft = Math.max(0, amelStack.method_7947() - currentLimit);
        user.method_6122(
            amelHand,
            // <= just to be safe
            amelWillBeLeft <= 0 ?
                class_1799.field_8037.method_7972() :
                new class_1799(
                    amelStack.method_7909(),
                    amelWillBeLeft
                )
        );
        this.setStored(stack, Math.min(this.maxAmel, currentlyStored + amelStack.method_7947()));
        return class_1271.method_29237(stack, true);
    }

    public class_1271<class_1799> withdraw(
        class_1657 user,
        class_1268 hand,
        class_1799 stack,
        List<class_1268> otherHands
    ) {
        class_1268 depositHand = null;
        class_1799 depositStack = null;
        for (class_1268 selectedHand : otherHands) {
            class_1799 possiblyDeposit = user.method_5998(selectedHand);
            if (!(Mutables.isAmel(possiblyDeposit) || possiblyDeposit.method_7960())) continue;
            depositHand = selectedHand;
        }
        if (depositHand == null) return class_1271.method_22431(stack);
        depositStack = user.method_5998(depositHand);
        int withdrawAmel = Math.min(
            64 - depositStack.method_7947(),
            this.getStored(stack)
        );
        user.method_6122(
            depositHand,
            withdrawAmel == 0 ?
                class_1799.field_8037.method_7972() :
                new class_1799(ModItems.AMEL_ITEM, depositStack.method_7947() + withdrawAmel)
        );
        this.setStored(stack, this.getStored(stack) - withdrawAmel);
        return class_1271.method_29237(stack, true);
    }
    
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        List<class_1268> hands = getAllHands();
        hands.remove(hand);
        class_1799 stack = user.method_5998(hand);
        return user.method_5715() ? withdraw(user, hand, stack, hands) : deposit(user, hand, stack, hands);
    }

    public int getStored(class_1799 stack) { return NBTHelper.getInt(stack, STORED_AMEL); }
    public void setStored(class_1799 stack, int count) { NBTHelper.putInt(stack, STORED_AMEL, count); }

    @Override
    public void method_7851(
        class_1799 stack,
        @Nullable class_1937 world,
        List<class_2561> components,
        class_1836 flag
    ) {
        components.add(
            class_2561.method_43471("tooltips.lapisworks.amel_jar.pre")
                .method_27692(class_124.field_1064)
                .method_10852(class_2561.method_43470(String.valueOf(this.getStored(stack))).method_27692(class_124.field_1078))
        );
    }

    @Override
    public boolean canAccess(Flags flags) {
        return this.worksInHotbar ? true : !flags.canWorkIn(Flags.INVITEM, Flags.HOTBAR) &&
                !flags.canWorkIn(Flags.INVITEM, Flags.INVENTORY);
    }
    @Override
    public int fetch(class_1799 stack, Predicate<class_1792> item) {
        if (!item.test(ModItems.AMEL_ITEM)) return 0;
        return this.getStored(stack);
    }
    @Override
    public int drain(class_1799 stack, Predicate<class_1792> item, int count) {
        LOGGER.info("Testing.. " + item.test(ModItems.AMEL_ITEM));
        if (!item.test(ModItems.AMEL_ITEM)) return count;
        int takeAway = Math.min(this.getStored(stack), count);
        int remainingInStore = this.getStored(stack) - takeAway;
        int remainingToTake = count - takeAway;
        this.setStored(stack, remainingInStore);
        LOGGER.info("they are requesting " + count + " from us.");
        LOGGER.info("we have " + remainingInStore + " left.");
        LOGGER.info("we have given " + takeAway + ".");
        LOGGER.info("they need " + remainingToTake + " more.");
        return remainingToTake;
    }
    @Override
    public int give(class_1799 stack, Predicate<class_1792> item, int count) {
        if (!item.test(ModItems.AMEL_ITEM)) return count;
        // by the power of the lord above my math will work
        int give = Math.min(this.maxAmel - this.getStored(stack), count);
        int remaining = Math.max(this.getStored(stack) + count - this.maxAmel, 0);
        this.setStored(stack, this.getStored(stack) + give);
        return remaining;
    }
}
