package com.luxof.lapisworks.mishaps;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;

import static com.luxof.lapisworks.Lapisworks.handToString;
import static com.luxof.lapisworks.LapisworksIDs.GENERIC_BADITEM;
import static com.luxof.lapisworks.LapisworksIDs.SPECHAND_BADITEM;
import static com.luxof.lapisworks.LapisworksIDs.SPECHAND_NOITEM;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

/** Yes, if you pass an empty ItemStack for item, it still works. */
public class MishapBadHandItem extends Mishap {
    public final class_1799 item;
    public final class_2561 wanted;
    public final class_1268 hand;
    public class_2561 gotItemDesc;
    
    private class_1799 emptyIfNull(class_1799 stack) {
        if (stack == null) { return class_1799.field_8037.method_7972(); }
        return stack;
    }

    public MishapBadHandItem(@Nullable class_1799 item, class_2561 wanted, class_1268 hand) {
        this.item = emptyIfNull(item);
        this.wanted = wanted;
        this.hand = hand;
    }
    public MishapBadHandItem(@Nullable class_1799 item, class_1792 wanted, class_1268 hand) {
        this.item = emptyIfNull(item);
        this.wanted = wanted.method_7848();
        this.hand = hand;
    }
    /** Replaces the period usually at the end of bad_item (not no_item) with gotItemDesc. */
    public MishapBadHandItem(@Nullable class_1799 item, class_2561 wanted, class_2561 gotItemDesc, class_1268 hand) {
        this.item = emptyIfNull(item);
        this.wanted = wanted;
        this.hand = hand;
        this.gotItemDesc = gotItemDesc;
    }

    @Override
    public FrozenPigment accentColor(CastingEnvironment ctx, Context errorCtx) {
        return dyeColor(class_1767.field_7957);
    }

    @Override
    protected class_2561 errorMessage(CastingEnvironment ctx, Context errorCtx) {
        if (this.item.method_7960()) {
            return class_2561.method_43469(
                SPECHAND_NOITEM,
                this.wanted,
                handToString(this.hand)
            );
        } else {
            return class_2561.method_43469(
                SPECHAND_BADITEM,
                this.wanted,
                handToString(this.hand),
                // i could do another way with appending Text but then translator guy
                // would have to look at my code since it's not obvious in en_us.json
                this.gotItemDesc == null ? GENERIC_BADITEM : this.gotItemDesc,
                this.item.method_7947(),
                this.item.method_7964()
            );
        }
    }

    @Override
    public void execute(CastingEnvironment ctx, Context errorCtx, List<Iota> stack) {
        ctx.getMishapEnvironment().dropHeldItems();
    }
}
