package com.luxof.lapisworks.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import com.luxof.lapisworks.recipes.MoldRec.MoldRecJsonFormat;

import static com.luxof.lapisworks.Lapisworks.LOGGER;

import java.util.List;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MoldRecSerializer implements class_1865<MoldRec> {
    private MoldRecSerializer() {}
    public static final MoldRecSerializer INSTANCE = new MoldRecSerializer();

    private static boolean modsLoaded(List<String> mods) {
        for (String id : mods) { if (!FabricLoader.getInstance().isModLoaded(id)) return false; }
        return true;
    }

    @Override
    public MoldRec method_8121(class_2960 id, JsonObject json) {
        MoldRecJsonFormat recipeJson = new Gson().fromJson(json, MoldRecJsonFormat.class);
        if (recipeJson.input == null) {
            throw new JsonSyntaxException("Unspecified input for Mold Amel recipe: " + id);
        } else if (recipeJson.output == null) {
            throw new JsonSyntaxException("Unspecified output for Mold Amel recipe: " + id);
        }
        if (recipeJson.requiredmod != null &&
            !modsLoaded(recipeJson.requiredmod)) {
            LOGGER.info("Disabling the Mold Amel recipe.");
            LOGGER.info(recipeJson.requiredmod.toString());
            return new MoldRec(
                id,
                class_1856.method_8091(class_1802.field_8162),
                class_1802.field_8162,
                false
            );
        }
        class_1856 input = class_1856.method_52177(recipeJson.input);
        class_1792 output = class_7923.field_41178.method_17966(new class_2960(recipeJson.output))
            .orElseThrow(() -> new JsonSyntaxException("No such item for output: " + recipeJson.output));

        return new MoldRec(id, input, output, true);
    }

    @Override
    public MoldRec method_8122(class_2960 id, class_2540 buf) {
        return new MoldRec(
            id,
            class_1856.method_8086(buf),
            class_7923.field_41178.method_10223(buf.method_10810()),
            buf.readBoolean()
        );
    }

    @Override
    public void write(class_2540 buf, MoldRec recipe) {
        recipe.getInput().method_8088(buf);
        buf.method_10812(class_7923.field_41178.method_10221(recipe.getOutput()));
        buf.writeBoolean(recipe.getEnabled());
    }
}
