/*
 * Decompiled with CFR 0.152.
 */
package com.luxof.lapisworks.blocks.entities;

import com.luxof.lapisworks.blocks.Mind;
import com.luxof.lapisworks.init.ModBlocks;
import com.luxof.lapisworks.mixinsupport.ArtMindInterface;
import java.util.ArrayList;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class MindEntity
extends class_2586 {
    public float mindCompletion = 0.0f;
    public static int maxVillagersForBrainGather = 3;
    public static int gatherRange = 5;
    public static float villagerExhaustionRate = 0.020833334f;
    public static int villagerExhaustRegenCD = 400;
    public static int sleepingVillagerUseAgainCD = 24000;
    public static float mindCompleteRatePerVillager = 0.004166667f;

    public MindEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MIND_ENTITY_TYPE, pos, state);
    }

    public long getMaxMediaGainFromAbsorption() {
        return 100000L;
    }

    public static int computeFilledState(float filledPercent) {
        return (int)Math.max(Math.min(Math.floor((double)filledPercent / 7.14), 14.0), 0.0);
    }

    public static void consumeVillagerMinds(class_1937 world, class_2338 pos, MindEntity blockEntity) {
        class_243 topLeftBack = pos.method_46558().method_1023((double)gatherRange, (double)gatherRange, (double)gatherRange);
        class_243 bottomRightFront = pos.method_46558().method_1031((double)gatherRange, (double)gatherRange, (double)gatherRange);
        ArrayList villagersNear = new ArrayList(world.method_8390(class_1646.class, new class_238(topLeftBack, bottomRightFront), villager -> ((ArtMindInterface)villager).getUsedMindPercentage() < 100.0f && ((ArtMindInterface)villager).getDontUseAgainTicks() <= 0));
        int usedVillagersCount = 0;
        for (int i = 0; i < Math.min(villagersNear.size(), maxVillagersForBrainGather); ++i) {
            int idx = world.field_9229.method_43048(villagersNear.size());
            class_1646 villager2 = (class_1646)villagersNear.get(idx);
            if (villager2.method_6113() && usedVillagersCount == 0) {
                blockEntity.mindCompletion += 15.0f;
                blockEntity.mindCompletion = Math.min(100.0f, blockEntity.mindCompletion);
                ((ArtMindInterface)villager2).setDontUseAgainTicks(sleepingVillagerUseAgainCD);
                break;
            }
            ++usedVillagersCount;
            villagersNear.remove(idx);
            ((ArtMindInterface)villager2).incUsedMindPercentage(villagerExhaustionRate);
            ((ArtMindInterface)villager2).setMindBeingUsedTicks(villagerExhaustRegenCD);
            blockEntity.mindCompletion += mindCompleteRatePerVillager;
            blockEntity.mindCompletion = Math.min(100.0f, blockEntity.mindCompletion);
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 bE) {
        if (world.field_9236) {
            return;
        }
        MindEntity blockEntity = (MindEntity)bE;
        if (blockEntity.mindCompletion < 100.0f) {
            MindEntity.consumeVillagerMinds(world, pos, blockEntity);
        }
        int shouldBeAtState = MindEntity.computeFilledState(blockEntity.mindCompletion);
        if ((Integer)state.method_11654((class_2769)Mind.FILLED) != shouldBeAtState) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)Mind.FILLED, (Comparable)Integer.valueOf(shouldBeAtState)));
        }
        blockEntity.method_5431();
        if (!world.field_9236) {
            world.method_8413(pos, state, state, 3);
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("mindCompletion", this.mindCompletion);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.mindCompletion = nbt.method_10583("mindCompletion");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

