/*
 * Decompiled with CFR 0.152.
 */
package net.wh0oo.deepchat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DeepChatMod
implements ModInitializer {
    private static final String CONFIG_DIR = "config/deepchat/";
    private static final String API_KEY_PATH = "config/deepchat/api_key.txt";
    private static final String MODEL_PATH = "config/deepchat/model.txt";
    private static final String[] VALID_MODELS = new String[]{"deepseek-chat", "deepseek-reasoner"};
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private final Map<UUID, Long> lastQueryTimes = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 3000L;
    private static final int MAX_CHUNKS = 3;
    private static final int SINGLE_MESSAGE_THRESHOLD = 240;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();

    public void onInitialize() {
        this.setupConfigFiles();
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            String msg = message.method_46291().getString();
            if (msg.startsWith("!ai ")) {
                String finalQuery;
                Integer maxChars;
                class_2168 source = sender.method_5682().method_3739();
                UUID playerId = sender.method_5667();
                String query = msg.substring(4).trim();
                Matcher matcher = Pattern.compile("\\[max=(\\d+)\\]").matcher(query);
                if (matcher.find()) {
                    maxChars = Integer.parseInt(matcher.group(1));
                    finalQuery = query.replace(matcher.group(0), "").trim();
                } else {
                    maxChars = null;
                    finalQuery = query;
                }
                if (source == null || source.method_9211() == null) {
                    System.err.println("[ERROR] Invalid command source");
                    return;
                }
                if (System.currentTimeMillis() - this.lastQueryTimes.getOrDefault(playerId, 0L) < 3000L) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Please wait 3 seconds between queries!"));
                    return;
                }
                this.lastQueryTimes.put(playerId, System.currentTimeMillis());
                this.executor.submit(() -> this.processQueryAsync(source, finalQuery, maxChars));
            }
        });
    }

    private void setupConfigFiles() {
        try {
            Files.createDirectories(Paths.get(CONFIG_DIR, new String[0]), new FileAttribute[0]);
            if (!Files.exists(Paths.get(API_KEY_PATH, new String[0]), new LinkOption[0])) {
                Files.write(Paths.get(API_KEY_PATH, new String[0]), "paste-your-key-here".getBytes(), new OpenOption[0]);
            }
            if (!Files.exists(Paths.get(MODEL_PATH, new String[0]), new LinkOption[0])) {
                Files.write(Paths.get(MODEL_PATH, new String[0]), "deepseek-chat".getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            System.err.println("Config Error: " + e.getMessage());
        }
    }

    private void processQueryAsync(class_2168 source, String query, Integer maxChars) {
        try {
            System.out.println("[DeepChat] Processing: " + query);
            String response = this.processQueryWithRetry(query, maxChars);
            if (response == null || response.trim().isEmpty()) {
                throw new IOException("Empty API response");
            }
            this.executeServerSay(source.method_9211(), this.cleanMessage(response), maxChars);
        }
        catch (Exception e) {
            System.err.println("[ERROR] " + e.getMessage());
            source.method_9213((class_2561)class_2561.method_43470((String)("AI Error: " + e.getMessage().replaceAll("(?i)api key", "[REDACTED]"))));
        }
    }

    private String cleanMessage(String message) {
        return message.replace("**", "").replace("*", "").replace("`", "").replace("#", "").replace("\n", " ").replace("\"", "'");
    }

    private String processQueryWithRetry(String query, Integer maxChars) throws Exception {
        String apiKey = Files.readString(Paths.get(API_KEY_PATH, new String[0])).trim();
        String model = this.validateModel(Files.readString(Paths.get(MODEL_PATH, new String[0])).trim());
        String jsonPayload = this.buildRequestJson(model, query, maxChars);
        Request request = new Request.Builder().url("https://api.deepseek.com/v1/chat/completions").header("Authorization", "Bearer " + apiKey).post(RequestBody.create((String)jsonPayload, (MediaType)JSON)).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String rawResponse = response.body().string();
            if (!response.isSuccessful()) {
                throw new IOException("HTTP " + response.code() + ": " + rawResponse);
            }
            String string = this.parseResponse(rawResponse);
            return string;
        }
    }

    private String validateModel(String model) {
        return Arrays.asList(VALID_MODELS).contains(model.toLowerCase()) ? model : "deepseek-chat";
    }

    private String buildRequestJson(String model, String query, Integer maxChars) {
        JsonObject request = new JsonObject();
        request.addProperty("model", model);
        if (maxChars != null) {
            request.addProperty("max_tokens", (Number)(maxChars / 4));
        }
        JsonArray messages = new JsonArray();
        JsonObject message = new JsonObject();
        message.addProperty("role", "user");
        message.addProperty("content", query);
        messages.add((JsonElement)message);
        request.add("messages", (JsonElement)messages);
        return request.toString();
    }

    private String parseResponse(String rawResponse) throws IOException {
        JsonObject json = JsonParser.parseString((String)rawResponse).getAsJsonObject();
        if (json.has("error")) {
            throw new IOException(json.get("error").toString());
        }
        return json.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
    }

    private void executeServerSay(MinecraftServer server, String message, Integer maxChars) {
        try {
            int remainingLength;
            int splitAt;
            if (server == null || !server.method_3806()) {
                return;
            }
            if (maxChars != null) {
                message = message.substring(0, Math.min(message.length(), maxChars));
            }
            if (message.length() <= 240) {
                server.method_3734().method_44252(server.method_3739().method_9206(4), "say [AI] " + message);
                return;
            }
            ArrayList<String> chunks = new ArrayList<String>();
            int start = 0;
            for (remainingLength = message.length(); remainingLength > 0 && chunks.size() < 2; remainingLength -= splitAt - start) {
                int chunkLength = Math.min(220, remainingLength);
                splitAt = message.lastIndexOf(32, start + chunkLength);
                if (splitAt <= start) {
                    splitAt = start + chunkLength;
                }
                chunks.add(message.substring(start, splitAt).trim());
                start = splitAt;
            }
            if (remainingLength > 0) {
                Object lastChunk = message.substring(start);
                if (chunks.size() == 2) {
                    lastChunk = "[...] " + ((String)lastChunk).substring(0, Math.min(100, ((String)lastChunk).length()));
                }
                chunks.add((String)lastChunk);
            }
            for (int i = 0; i < chunks.size(); ++i) {
                server.method_3734().method_44252(server.method_3739().method_9206(4), String.format("say [AI %d/%d] %s", i + 1, chunks.size(), chunks.get(i)));
            }
        }
        catch (Exception e) {
            System.err.println("[Broadcast] Failed: " + e.getMessage());
        }
    }

    public void onDisable() {
        this.executor.shutdown();
    }
}

