/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command;

import net.minecraft.world.entity.Entity;
import org.thexeler.freeepicgames.command.lamp.actor.ForgeCommandActor;
import org.thexeler.freeepicgames.command.lamp.annotations.RequiresOP;
import org.thexeler.freeepicgames.command.lamp.annotations.WithNPC;
import org.thexeler.freeepicgames.command.lamp.annotations.WithNPCType;
import org.thexeler.freeepicgames.command.lamp.parameters.EntitySelectorList;
import org.thexeler.freeepicgames.database.agent.WorldNPCDataAgent;
import org.thexeler.freeepicgames.database.type.NPCType;
import org.thexeler.freeepicgames.database.view.NPCView;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;

@Command(value={"fegnpc"})
public class ModelNPCCommand {
    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"create <type>"})
    public void create(ForgeCommandActor sender, @WithNPCType NPCType type) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        if (agent.createNPC(type) != null) {
            sender.reply("\u6210\u529f\u521b\u5efaNPC");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"create <type> <origin>"})
    public void create(ForgeCommandActor sender, @WithNPCType NPCType type, Entity origin) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        if (agent.createNPC(type, origin) != null) {
            sender.reply("\u6210\u529f\u9644\u52a0NPC\u529f\u80fd\u5230\u5df2\u6709\u751f\u7269");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"create <type> <selector>"})
    public void create(ForgeCommandActor sender, @WithNPCType NPCType type, EntitySelectorList<Entity> selector) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            if (agent.createNPC(type, (Entity)entity) != null) {
                sender.reply("\u6210\u529f\u9644\u52a0NPC\u529f\u80fd\u5230\u5df2\u6709\u751f\u7269");
            } else {
                sender.reply("\u9644\u52a0\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"delete <id>"})
    public void delete(ForgeCommandActor sender, String id) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        if (agent.deleteNPC(id)) {
            sender.reply("\u6210\u529f\u5220\u9664NPC");
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"delete <selector>"})
    public void delete(ForgeCommandActor sender, EntitySelectorList<Entity> selector) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            if (agent.deleteNPC(entity.m_20149_())) {
                sender.reply("\u6210\u529f\u5220\u9664NPC");
            } else {
                sender.reply("\u5220\u9664\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"discard <id>"})
    public void discard(ForgeCommandActor sender, @WithNPC String id) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        NPCView npc = agent.getNPCView(id);
        if (npc != null) {
            npc.discard();
            sender.reply("\u6210\u529f\u5220\u9664NPC\u9644\u52a0\u6570\u636e");
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"discard <selector>"})
    public void discard(ForgeCommandActor sender, EntitySelectorList<Entity> selector) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            NPCView npc = agent.getNPCView(entity.m_20149_());
            if (npc != null) {
                npc.discard();
                sender.reply("\u6210\u529f\u5220\u9664NPC\u9644\u52a0\u6570\u636e");
            } else {
                sender.reply("\u5220\u9664\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"list"})
    public void list(ForgeCommandActor sender) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        sender.reply("\u5f53\u524d\u4e16\u754cNPC\u5217\u8868:");
        agent.getAllNPC().forEach(npc -> sender.reply(npc.getId()));
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"info <id>"})
    public void info(ForgeCommandActor sender, String id) {
        WorldNPCDataAgent agent = WorldNPCDataAgent.getInstance(sender.getLevel());
        NPCView npc = agent.getNPCView(id);
        if (npc != null) {
            sender.reply("NPC\u4fe1\u606f:");
            sender.reply("ID: " + npc.getId());
            sender.reply("\u7c7b\u578b: " + npc.getEntityType().getName());
            sender.reply("\u9644\u52a0\u6570\u636e: ");
            npc.getNpcData().forEach((name, value) -> sender.reply("- " + name + ": " + value));
        }
    }
}

