/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command.lamp.parameters;

import com.google.common.collect.ForwardingList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.command.lamp.actor.ForgeCommandActor;
import org.thexeler.freeepicgames.command.lamp.exception.EmptyEntitySelectorException;
import org.thexeler.freeepicgames.command.lamp.exception.MalformedEntitySelectorException;
import org.thexeler.freeepicgames.command.lamp.parameters.EntitySelectorList;
import revxrsal.commands.Lamp;
import revxrsal.commands.annotation.list.AnnotationList;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.util.Classes;
import revxrsal.commands.util.Preconditions;

public final class EntitySelectorListParameterTypeFactory
implements ParameterType.Factory<ForgeCommandActor> {
    @Override
    @Nullable
    public <T> ParameterType<ForgeCommandActor, T> create(@NotNull Type parameterType, @NotNull AnnotationList annotations, @NotNull Lamp<ForgeCommandActor> lamp) {
        Class<?> rawType = Classes.getRawType(parameterType);
        if (rawType != EntitySelectorList.class) {
            return null;
        }
        Class<Entity> entityClass = Classes.getRawType(Classes.getFirstGeneric(parameterType, Entity.class)).asSubclass(Entity.class);
        return new EntitySelectorListParameterType(entityClass);
    }

    static final class EntitySelectorListParameterType
    implements ParameterType<ForgeCommandActor, EntitySelectorList<? extends Entity>> {
        private final Class<?> entityType;

        public EntitySelectorListParameterType(Class<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public EntitySelectorList<? extends Entity> parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<ForgeCommandActor> context) {
            String selectorString = input.readString();
            try {
                EntitySelector selector = new EntitySelectorParser(new StringReader(selectorString)).m_121230_();
                ArrayList<Entity> c = new ArrayList<Entity>(selector.m_121160_(context.actor().source()));
                c.removeIf(obj -> !this.entityType.isInstance(obj));
                if (c.isEmpty()) {
                    throw new EmptyEntitySelectorException(selectorString);
                }
                return new SelectorList(c);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedEntitySelectorException(selectorString, e.getCause().getMessage());
            }
            catch (CommandSyntaxException e) {
                throw new CommandErrorException(e.getCause().getMessage(), new Object[0]);
            }
            catch (NoSuchMethodError e) {
                throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
            }
        }
    }

    static final class SelectorList<E extends Entity>
    extends ForwardingList<E>
    implements EntitySelectorList<E> {
        private final List<E> entities;

        public SelectorList(List<E> entities) {
            this.entities = Preconditions.notNull(entities, "entities list");
        }

        @NotNull
        protected List<E> delegate() {
            return this.entities;
        }
    }
}

