/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.agent;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.type.NPCType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.untils.ModSavedData;
import org.thexeler.freeepicgames.database.view.NPCView;
import org.thexeler.freeepicgames.events.NPCEvent;

public class WorldNPCDataAgent
implements AbstractDataAgent {
    private static final Map<ServerLevel, WorldNPCDataAgent> instances = new HashMap<ServerLevel, WorldNPCDataAgent>();
    private final ServerLevel world;
    private final JsonObject optionData;
    private final JsonObject npcData;
    private final Map<String, NPCView> npcViewMap = Collections.synchronizedMap(new HashMap());

    private WorldNPCDataAgent(ServerLevel world) {
        this.world = world;
        this.optionData = ModSavedData.getWorldData((Level)world, "NPCSettings");
        this.npcData = ModSavedData.getWorldData((Level)world, "NPCData");
        this.load();
    }

    public static WorldNPCDataAgent getInstance(ServerLevel world) {
        return instances.computeIfAbsent(world, WorldNPCDataAgent::new);
    }

    public Collection<NPCView> getAllNPC() {
        return this.npcViewMap.values();
    }

    public NPCView createNPC(NPCType type) {
        return this.createNPC(type, null);
    }

    public NPCView createNPC(NPCType type, Entity origin) {
        NPCView view = null;
        if (origin == null) {
            origin = type.getEntityType().m_20615_((Level)this.world);
        }
        if (origin != null) {
            if (this.npcData.get(origin.m_20149_()) == null) {
                view = new NPCView(origin, type, this);
                origin.m_20331_(type.isInvulnerable());
                origin.m_6842_(type.isInvisible());
                origin.m_20242_(type.isNoGravity());
                CompoundTag tags = origin.serializeNBT();
                if (type.isNoAI()) {
                    tags.m_128405_("NoAI", 1);
                }
                origin.deserializeNBT(tags);
                MinecraftForge.EVENT_BUS.post((Event)new NPCEvent.NPCCreateEvent(view));
                this.world.m_7967_(origin);
                MinecraftForge.EVENT_BUS.post((Event)new NPCEvent.NPCJoinEvent(view, this.world));
                this.npcViewMap.put(view.getId(), view);
            } else {
                FreeEpicGames.LOGGER.error("NPC {} already exists", (Object)origin.m_20149_());
            }
        } else {
            FreeEpicGames.LOGGER.error("Entity type {} not found", type.getEntityType());
        }
        return view;
    }

    public boolean deleteNPC(String id) {
        if (this.npcViewMap.get(id) != null) {
            this.npcViewMap.get(id).discard();
            this.npcViewMap.remove(id);
            return true;
        }
        return false;
    }

    @Nullable
    public NPCView getNPCView(String id) {
        return this.npcViewMap.get(id);
    }

    @Override
    public void load() {
        this.npcData.keySet().forEach(id -> {
            NPCView view = new NPCView(this.npcData.getAsJsonObject(id), this);
            if (view.getOriginEntity() == null) {
                this.npcViewMap.put((String)id, view);
            }
        });
    }

    @Override
    public void save() {
        DataUtils.computeViewMap(this.npcViewMap, this.npcData);
    }

    public ServerLevel getWorld() {
        return this.world;
    }
}

