/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.view;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.agent.WorldNPCDataAgent;
import org.thexeler.freeepicgames.database.type.NPCType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.AbstractView;

public class NPCView
implements AbstractView {
    private final WorldNPCDataAgent rootAgent;
    private final String id;
    private final NPCType entityType;
    private final Entity originEntity;
    private final HashMap<String, String> npcData;

    public NPCView(@NotNull Entity origin, NPCType type, WorldNPCDataAgent agent) {
        this.rootAgent = agent;
        this.originEntity = origin;
        this.id = origin.m_20149_();
        this.entityType = type;
        this.npcData = new HashMap();
    }

    public NPCView(JsonObject object, WorldNPCDataAgent agent) {
        this.rootAgent = agent;
        this.id = DataUtils.getValue(object, "id", "");
        this.entityType = NPCType.getType(DataUtils.getValue(object, "type", ""));
        this.originEntity = agent.getWorld().m_8791_(UUID.fromString(this.id));
        this.npcData = new HashMap();
    }

    public void discard() {
        this.discardAdditional();
        if (this.originEntity != null) {
            this.originEntity.m_146870_();
        }
    }

    public void discardAdditional() {
        this.rootAgent.deleteNPC(this.id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NPCView getEntity(Entity entity) {
        try (Level level = entity.m_9236_();){
            if (!(level instanceof ServerLevel)) return null;
            ServerLevel serverLevel = (ServerLevel)level;
            NPCView nPCView = NPCView.getEntity(serverLevel, entity.m_20148_());
            return nPCView;
        }
        catch (IOException e) {
            FreeEpicGames.LOGGER.error(e.getMessage());
        }
        return null;
    }

    public static NPCView getEntity(ServerLevel level, UUID uuid) {
        return NPCView.getEntity(level, uuid.toString());
    }

    public static NPCView getEntity(ServerLevel level, String id) {
        return WorldNPCDataAgent.getInstance(level).getNPCView(id);
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        Gson gson = new Gson();
        jsonObject.addProperty("id", this.id);
        jsonObject.addProperty("type", this.entityType.getName());
        JsonObject npcDataJson = new JsonObject();
        this.npcData.forEach((arg_0, arg_1) -> ((JsonObject)npcDataJson).addProperty(arg_0, arg_1));
        jsonObject.add("npc_data", (JsonElement)npcDataJson);
        return jsonObject;
    }

    public String getId() {
        return this.id;
    }

    public NPCType getEntityType() {
        return this.entityType;
    }

    public Entity getOriginEntity() {
        return this.originEntity;
    }

    public HashMap<String, String> getNpcData() {
        return this.npcData;
    }
}

