/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.type.RaidType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.AbstractCacheView;

public class RaidInstanceView
implements AbstractCacheView {
    private static final Map<String, RaidInstanceView> playerInstanceMappings = Collections.synchronizedMap(new HashMap());
    private final String id;
    private final RaidType baseType;
    private final ChunkPos startChunk;
    private final ChunkPos endChunk;
    private final Map<String, Vec3> playerCheckpointPosMap;
    private final Map<BlockPos, Container> sharedTreasuresMap;
    private final Map<String, Map<BlockPos, Container>> playerTreasuresMap;
    private boolean isActive;
    private final AABB frame;
    private final BlockPos blockPosOffset;

    public RaidInstanceView(String id, RaidType baseType, ChunkPos startChunk) {
        this.id = id;
        this.baseType = baseType;
        this.startChunk = startChunk;
        this.endChunk = new ChunkPos(SectionPos.m_123171_((int)(startChunk.m_45608_() + baseType.getSize().m_123341_())), SectionPos.m_123171_((int)(startChunk.m_45609_() + baseType.getSize().m_123343_())));
        this.playerCheckpointPosMap = new HashMap<String, Vec3>();
        this.sharedTreasuresMap = new HashMap<BlockPos, Container>();
        this.playerTreasuresMap = new HashMap<String, Map<BlockPos, Container>>();
        BlockPos startBlock = new BlockPos(startChunk.m_45604_(), 0, startChunk.m_45605_());
        BlockPos endBlock = new BlockPos(this.endChunk.m_45608_(), FreeEpicGames.RAID_WORLD.m_151558_(), this.endChunk.m_45609_());
        this.frame = new AABB(startBlock, endBlock);
        this.isActive = false;
        this.blockPosOffset = new BlockPos(startChunk.m_45604_(), 0, startChunk.m_45605_());
    }

    public RaidInstanceView(JsonObject object) {
        this.id = DataUtils.getValue(object, "uuid", UUID.randomUUID().toString());
        this.baseType = RaidType.getType(DataUtils.getValue(object, "base_type", ""));
        this.startChunk = new ChunkPos(object.get("start_chunk").getAsInt(), object.get("start_chunk").getAsInt());
        this.endChunk = new ChunkPos(object.get("end_chunk").getAsInt(), object.get("end_chunk").getAsInt());
        this.playerCheckpointPosMap = new HashMap<String, Vec3>();
        Map<String, JsonElement> checkPoints = DataUtils.getValue(object, "check_points", new HashMap<String, JsonElement>());
        checkPoints.forEach((uuid, infoElement) -> {
            JsonObject infoObject = infoElement.getAsJsonObject();
            this.playerCheckpointPosMap.put((String)uuid, new Vec3((double)DataUtils.getValue(infoObject, "x", 0.0f), (double)DataUtils.getValue(infoObject, "y", 0.0f), (double)DataUtils.getValue(infoObject, "z", 0.0f)));
        });
        this.sharedTreasuresMap = new HashMap<BlockPos, Container>();
        List<JsonElement> sharedTreasures = DataUtils.getValue(object, "shared_treasures", new ArrayList<JsonElement>());
        sharedTreasures.forEach(infoElement -> {
            JsonObject infoObject = infoElement.getAsJsonObject();
            JsonArray containerJson = DataUtils.getValue(infoObject, "container", new JsonArray());
            if (containerJson != null) {
                this.sharedTreasuresMap.put(new BlockPos(DataUtils.getValue(infoObject, "x", 0), DataUtils.getValue(infoObject, "y", 0), DataUtils.getValue(infoObject, "z", 0)), DataUtils.toContainer(containerJson));
            }
        });
        this.playerTreasuresMap = new HashMap<String, Map<BlockPos, Container>>();
        Map<String, JsonElement> allPlayerTreasures = DataUtils.getValue(object, "player_treasures", new HashMap<String, JsonElement>());
        allPlayerTreasures.forEach((uuid, playerTreasuresInfo) -> {
            JsonObject playerTreasuresInfoObject = playerTreasuresInfo.getAsJsonObject();
            Map playerTreasuresMap = this.playerTreasuresMap.computeIfAbsent((String)uuid, k -> new HashMap());
            List<JsonElement> playerTreasures = DataUtils.getValue(playerTreasuresInfoObject, "treasures", new ArrayList<JsonElement>());
            playerTreasures.forEach(playerTreasureInfo -> {
                JsonObject playerTreasureInfoObject = playerTreasureInfo.getAsJsonObject();
                JsonArray containerJson = DataUtils.getValue(playerTreasureInfoObject, "container", new JsonArray());
                playerTreasuresMap.put(new BlockPos(DataUtils.getValue(playerTreasureInfoObject, "x", 0), DataUtils.getValue(playerTreasureInfoObject, "y", 0), DataUtils.getValue(playerTreasureInfoObject, "z", 0)), DataUtils.toContainer(containerJson));
            });
        });
        BlockPos startBlock = new BlockPos(this.startChunk.m_45604_(), 0, this.startChunk.m_45605_());
        BlockPos endBlock = new BlockPos(this.endChunk.m_45608_(), FreeEpicGames.RAID_WORLD.m_151558_(), this.endChunk.m_45609_());
        this.frame = new AABB(startBlock, endBlock);
        this.isActive = DataUtils.getValue(object, "is_active", false);
        this.blockPosOffset = new BlockPos(this.startChunk.m_45604_(), 0, this.startChunk.m_45605_());
    }

    public MenuProvider getMenuProvider(ServerPlayer player, BlockPos blockPos) {
        RaidTreasureType treasure = this.baseType.getTreasureType(blockPos.m_121996_((Vec3i)this.blockPosOffset));
        Map actualMap = treasure.isPlayerOwn() ? this.sharedTreasuresMap : this.playerTreasuresMap.computeIfAbsent(player.m_20149_(), p -> new HashMap());
        return new SimpleMenuProvider((ci, i, p) -> {
            Container container = actualMap.computeIfAbsent(blockPos, bp -> {
                SimpleContainer simpleContainer = new SimpleContainer(27);
                treasure.generator((Container)simpleContainer);
                return simpleContainer;
            });
            return ChestMenu.m_39237_((int)ci, (Inventory)i, (Container)container);
        }, (Component)Component.m_237113_((String)treasure.getTitle()));
    }

    public boolean isInside(Vec3 pos) {
        return this.frame.m_82390_(pos);
    }

    public RaidTreasureType getTreasureType(BlockPos blockPos) {
        return this.baseType.getTreasureType(blockPos.m_121996_((Vec3i)this.blockPosOffset));
    }

    public void respawn(ServerPlayer player) {
        Vec3 checkpointPos = new Vec3(0.0, 0.0, 0.0);
        if (player.m_21224_()) {
            player.m_7583_();
        }
        player.m_264318_(FreeEpicGames.RAID_WORLD, checkpointPos.f_82479_, checkpointPos.f_82480_, checkpointPos.f_82481_, Collections.emptySet(), 0.0f, 0.0f);
    }

    public void setPlayer(ServerPlayer player, Vec3 checkpointPos) {
        playerInstanceMappings.put(player.m_20149_(), this);
        this.playerCheckpointPosMap.put(player.m_20149_(), checkpointPos);
        if (!FreeEpicGames.RAID_WORLD.m_6907_().contains(player)) {
            player.m_264318_(FreeEpicGames.RAID_WORLD, checkpointPos.f_82479_, checkpointPos.f_82480_, checkpointPos.f_82481_, Collections.emptySet(), 0.0f, 0.0f);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (player.m_8961_() != null) {
            this.removePlayer(player, player.m_8961_());
        } else {
            this.removePlayer(player, FreeEpicGames.OVER_WORLD.m_220360_());
        }
    }

    public void removePlayer(ServerPlayer player, BlockPos pos) {
        playerInstanceMappings.remove(player.m_20149_());
        this.playerCheckpointPosMap.remove(player.m_20149_());
        player.m_264318_(FreeEpicGames.OVER_WORLD, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Collections.emptySet(), player.m_146908_(), player.m_146909_());
    }

    public static RaidInstanceView getRaidInstanceFromPlayer(Player player) {
        return playerInstanceMappings.get(player.m_20149_());
    }

    public void build() {
        if (!this.isActive) {
            FreeEpicGames.LOGGER.info("Raid instance building: {}", (Object)this.id);
            int targetZ = 0;
            int chunkSizeX = this.endChunk.f_45578_ - this.startChunk.f_45578_;
            int chunkSizeZ = this.endChunk.f_45579_ - this.startChunk.f_45579_;
            for (int targetX = 0; targetX <= this.endChunk.f_45578_; ++targetX) {
                while (targetZ <= this.endChunk.f_45579_) {
                    LevelChunk chunk = FreeEpicGames.RAID_WORLD.m_6325_(targetX, targetZ);
                    ++targetZ;
                }
            }
            this.isActive = true;
        } else {
            FreeEpicGames.LOGGER.warn("Raid instance already active: {}", (Object)this.id);
        }
    }

    public void destroy() {
        if (this.isActive) {
            this.isActive = false;
        } else {
            FreeEpicGames.LOGGER.warn("Raid instance already inactive: {}", (Object)this.id);
        }
    }

    @Override
    public JsonObject toCacheJson() {
        JsonObject cacheInfo = new JsonObject();
        cacheInfo.addProperty("uuid", this.id);
        cacheInfo.addProperty("base_type", this.baseType.getName());
        cacheInfo.addProperty("start_chunk", this.startChunk.toString());
        cacheInfo.addProperty("end_chunk", this.endChunk.toString());
        JsonObject checkpointsJson = new JsonObject();
        this.playerCheckpointPosMap.forEach((u, v) -> {
            JsonObject posObject = new JsonObject();
            posObject.addProperty("x", (Number)v.f_82479_);
            posObject.addProperty("y", (Number)v.f_82480_);
            posObject.addProperty("z", (Number)v.f_82481_);
            checkpointsJson.add(u, (JsonElement)posObject);
        });
        cacheInfo.add("check_points", (JsonElement)checkpointsJson);
        JsonArray sharedTreasure = new JsonArray();
        this.sharedTreasuresMap.forEach((bp, c) -> {
            JsonObject treasureObject = new JsonObject();
            treasureObject.addProperty("x", (Number)bp.m_123341_());
            treasureObject.addProperty("y", (Number)bp.m_123342_());
            treasureObject.addProperty("z", (Number)bp.m_123343_());
            treasureObject.add("container", (JsonElement)DataUtils.fromContainer(c));
            sharedTreasure.add((JsonElement)treasureObject);
        });
        cacheInfo.add("shared_treasures", (JsonElement)sharedTreasure);
        JsonObject allPlayerTreasures = new JsonObject();
        this.playerTreasuresMap.forEach((p, pc) -> {
            JsonArray playerTreasures = new JsonArray();
            pc.forEach((bp, c) -> {
                JsonObject treasureObject = new JsonObject();
                treasureObject.addProperty("x", (Number)bp.m_123341_());
                treasureObject.addProperty("y", (Number)bp.m_123342_());
                treasureObject.addProperty("z", (Number)bp.m_123343_());
                treasureObject.add("container", (JsonElement)DataUtils.fromContainer(c));
                playerTreasures.add((JsonElement)treasureObject);
            });
            allPlayerTreasures.add(p, (JsonElement)playerTreasures);
        });
        cacheInfo.add("player_treasures", (JsonElement)allPlayerTreasures);
        return cacheInfo;
    }

    public String getId() {
        return this.id;
    }
}

