/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.thexeler.freeepicgames.database.view.NPCView;

public class NPCEvent
extends EntityEvent {
    private final NPCView NPCView;

    public NPCEvent(NPCView entity) {
        super(entity.getOriginEntity());
        this.NPCView = entity;
    }

    public NPCView getNPCView() {
        return this.NPCView;
    }

    public static class NPCTickEvent
    extends NPCEvent {
        public NPCTickEvent(NPCView entity) {
            super(entity);
        }
    }

    @Cancelable
    public static class NPCDamageEvent
    extends NPCEvent {
        private final DamageSource source;
        private final float amount;

        public NPCDamageEvent(NPCView entity, DamageSource source, float amount) {
            super(entity);
            this.source = source;
            this.amount = amount;
        }

        public DamageSource getSource() {
            return this.source;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    public static class NPCInteractEvent
    extends NPCEvent {
        private final Player player;

        public NPCInteractEvent(NPCView entity, Player player) {
            super(entity);
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class NPCDeathEvent
    extends NPCEvent {
        private final DamageSource source;

        public NPCDeathEvent(NPCView entity, DamageSource source) {
            super(entity);
            this.source = source;
        }

        public DamageSource getSource() {
            return this.source;
        }
    }

    public static class NPCJoinEvent
    extends NPCEvent {
        private final ServerLevel level;

        public NPCJoinEvent(NPCView entity, ServerLevel level) {
            super(entity);
            this.level = level;
        }

        public ServerLevel getLevel() {
            return this.level;
        }
    }

    public static class NPCCreateEvent
    extends NPCEvent {
        public NPCCreateEvent(NPCView entity) {
            super(entity);
        }
    }
}

