/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;

@Mod.EventBusSubscriber
public class RaidEventHandler {
    @SubscribeEvent
    public static void onOpenContainer(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            RaidTreasureType treasure;
            GlobalRaidDataAgent agent;
            RaidInstanceView view;
            ServerPlayer player2 = (ServerPlayer)player;
            if (FreeEpicGames.RAID_WORLD.equals(event.getLevel()) && (view = (agent = GlobalRaidDataAgent.getInstance()).getRaidInstance(player2)) != null && (treasure = view.getTreasureType(event.getPos())) != null) {
                player2.m_5893_(view.getMenuProvider(player2, event.getPos()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player2);
            if (view != null) {
                view.respawn(player2);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player2);
            if (view != null) {
                view.respawn(player2);
                event.setCanceled(true);
            }
        }
    }
}

