/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.npc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.thexeler.freeepicgames.npc.NPC;

public class NPCEvent
extends EntityEvent {
    private final NPC<?> NPC;

    public NPCEvent(NPC<?> entity) {
        super(entity.getOriginEntity());
        this.NPC = entity;
    }

    public NPC<?> getNPC() {
        return this.NPC;
    }

    public static class NPCTickEvent
    extends NPCEvent {
        public NPCTickEvent(NPC<?> entity) {
            super(entity);
        }
    }

    @Cancelable
    public static class NPCDamageEvent
    extends NPCEvent {
        private final DamageSource source;
        private final float amount;

        public NPCDamageEvent(NPC<?> entity, DamageSource source, float amount) {
            super(entity);
            this.source = source;
            this.amount = amount;
        }

        public DamageSource getSource() {
            return this.source;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    public static class NPCInteractEvent
    extends NPCEvent {
        private final Player player;

        public NPCInteractEvent(NPC<?> entity, Player player) {
            super(entity);
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class NPCDeathEvent
    extends NPCEvent {
        private final DamageSource source;

        public NPCDeathEvent(NPC<?> entity, DamageSource source) {
            super(entity);
            this.source = source;
        }

        public DamageSource getSource() {
            return this.source;
        }
    }

    public static class NPCJoinEvent
    extends NPCEvent {
        private final ServerLevel level;

        public NPCJoinEvent(NPC<?> entity, ServerLevel level) {
            super(entity);
            this.level = level;
        }

        public ServerLevel getLevel() {
            return this.level;
        }
    }

    public static class NPCCreateEvent
    extends NPCEvent {
        public NPCCreateEvent(NPC<?> entity) {
            super(entity);
        }
    }
}

