/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.thexeler.freeepicgames.database.agent.GlobalJobDataAgent;
import org.thexeler.freeepicgames.database.type.JobType;
import org.thexeler.lamp.actor.ForgeCommandActor;
import org.thexeler.lamp.annotations.RequiresOP;
import org.thexeler.lamp.annotations.WithJobType;
import org.thexeler.lamp.parameters.EntitySelectorList;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;

@Command(value={"fegjob"})
public class ModelJobCommand {
    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job create <name>"})
    public void jobCreate(ForgeCommandActor actor, String name) {
        if (JobType.register(name, new JsonObject())) {
            actor.reply("\u6210\u529f\u521b\u5efa\u804c\u4e1a" + name);
        } else {
            actor.reply("\u521b\u5efa\u5931\u8d25:\u5df2\u5b58\u5728\u7684\u804c\u4e1a" + name);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job delete <name>"})
    public void jobDelete(ForgeCommandActor actor, @WithJobType String name) {
        if (JobType.unregister(name)) {
            actor.reply("\u6210\u529f\u5220\u9664\u804c\u4e1a" + name);
        } else {
            actor.reply("\u5220\u9664\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a" + name);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job remove <name>"})
    public void jobRemove(ForgeCommandActor sender, @WithJobType String name) {
        ServerPlayer senderPlayer = sender.requirePlayer();
        if (senderPlayer != null) {
            JobType type = JobType.getType(name);
            if (type != null) {
                type.removeItem(senderPlayer.m_21205_());
                sender.reply("\u5df2\u6e05\u7a7a\u6307\u5b9a\u7269\u54c1");
            } else {
                sender.error("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a");
            }
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job set <name>"})
    public void jobSet(ForgeCommandActor sender, @WithJobType String name) {
        ServerPlayer senderPlayer = sender.requirePlayer();
        if (senderPlayer != null) {
            ItemStack stack = senderPlayer.m_21205_();
            if (!stack.m_150930_(Items.f_41852_)) {
                JobType type = JobType.getType(name);
                if (type != null) {
                    type.setItem(stack);
                    sender.reply("\u5df2\u5c06\u804c\u4e1a" + name + "\u4e2d\u7684\u7269\u54c1" + stack.m_41611_() + "\u8bbe\u7f6e\u4e3a" + stack.m_41613_() + "\u4e2a");
                } else {
                    sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a\u6216\u7269\u54c1\u7c7b\u578b");
                }
            } else {
                sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u76ee\u6807\u7269\u54c1\u4e3a\u7a7a");
            }
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job set <name> <num>"})
    public void jobSet(ForgeCommandActor sender, @WithJobType String name, int num) {
        ServerPlayer senderPlayer = sender.requirePlayer();
        if (senderPlayer != null) {
            ItemStack stack = senderPlayer.m_21205_();
            if (!stack.m_150930_(Items.f_41852_)) {
                JobType type = JobType.getType(name);
                if (type != null) {
                    type.setItem(stack, num);
                    sender.reply("\u5df2\u5c06\u804c\u4e1a" + name + "\u4e2d\u7684\u7269\u54c1" + stack.m_41611_() + "\u8bbe\u7f6e\u4e3a" + stack.m_41613_() + "\u4e2a");
                } else {
                    sender.error("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a");
                }
            } else {
                sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u76ee\u6807\u7269\u54c1\u4e3a\u7a7a");
            }
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"job list"})
    public void listJob(ForgeCommandActor sender) {
        List<String> jobs = JobType.getAllTypeName();
        StringBuilder message = new StringBuilder("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u5171\u8ba1" + jobs.size() + "\u4e2a\u804c\u4e1a\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        jobs.forEach(value -> message.append((String)value).append("\n"));
        message.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        sender.reply(message.toString());
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"player get <player>"})
    public void playerGet(ForgeCommandActor sender, ServerPlayer player) {
        GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
        sender.reply("\u73a9\u5bb6" + player.m_5446_() + "\u7684\u804c\u4e1a\u4e3a:" + agent.getPlayerJob(player));
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"player set <player> <name>"})
    public void playerSet(ForgeCommandActor sender, ServerPlayer player, @WithJobType String name) {
        GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
        if (agent.setPlayerJob(player, name)) {
            sender.reply("\u73a9\u5bb6" + player.m_5446_().getString() + "\u5df2\u88ab\u8bbe\u7f6e\u4e3a" + name);
        } else {
            sender.error("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"player set <selector> <name>"})
    public void playerSet(ForgeCommandActor sender, EntitySelectorList<ServerPlayer> selector, @WithJobType String name) {
        GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
        selector.stream().filter(entity -> entity instanceof ServerPlayer).forEach(player -> {
            if (agent.setPlayerJob((ServerPlayer)player, name)) {
                sender.reply("\u73a9\u5bb6" + player.m_5446_().getString() + "\u5df2\u88ab\u8bbe\u7f6e\u4e3a" + name);
            } else {
                sender.error("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u804c\u4e1a");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"player refresh <player>"})
    public void playerRefresh(ForgeCommandActor sender, ServerPlayer player) {
        GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
        JobType type = JobType.getType(agent.getPlayerJob(player));
        player.m_150109_().m_6211_();
        if (type != null) {
            type.getAllItems().forEach(stack -> player.m_150109_().m_36054_(stack));
        }
        sender.reply("\u5df2\u5237\u65b0\u73a9\u5bb6" + player.m_5446_().getString() + "\u7684\u80cc\u5305");
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"player refresh <selector>"})
    public void playerRefresh(ForgeCommandActor sender, EntitySelectorList<ServerPlayer> selector) {
        GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
        selector.stream().filter(entity -> entity instanceof ServerPlayer).forEach(player -> {
            JobType type = JobType.getType(agent.getPlayerJob((ServerPlayer)player));
            player.m_150109_().m_6211_();
            if (type != null) {
                type.getAllItems().forEach(stack -> player.m_150109_().m_36054_(stack));
            }
            sender.reply("\u5df2\u5237\u65b0\u73a9\u5bb6" + player.m_5446_().getString() + "\u7684\u80cc\u5305");
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"bind <command>"})
    public void bind(ForgeCommandActor sender, String command) {
        ServerPlayer player = sender.requirePlayer();
        if (player != null) {
            ItemStack stack = player.m_21205_();
            if (!stack.m_150930_(Items.f_41852_)) {
                CompoundTag data = stack.m_41783_();
                if (data == null) {
                    data = new CompoundTag();
                }
                data.m_128365_("custom_command", (Tag)StringTag.m_129297_((String)command));
                stack.m_41751_(data);
                sender.reply("\u547d\u4ee4\u7ed1\u5b9a\u6210\u529f");
            } else {
                sender.reply("\u7ed1\u5b9a\u5931\u8d25:\u76ee\u6807\u7269\u54c1\u4e3a\u7a7a");
            }
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"reload"})
    public void reload(ForgeCommandActor sender) {
        sender.reply("\u6b63\u5728\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6...");
        JobType.expire();
        JobType.init();
        sender.reply("\u914d\u7f6e\u6587\u4ef6\u91cd\u8f7d\u5b8c\u6210");
    }
}

