/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesPaths;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.untils.DataPacket;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;
import org.thexeler.slacker.utils.IOUtilities;

public class RaidType {
    private static final Map<String, RaidType> types = new HashMap<String, RaidType>();
    private final String name;
    private final int sizeX;
    private final int sizeZ;
    private final BlockPos spawnAreaStart;
    private final BlockPos spawnAreaEnd;
    private final List<CompoundTag> chunkTemplates;
    private final Map<BlockPos, RaidTreasureType> treasuresMap;

    private RaidType(String name, BlockPos spawnAreaStart, BlockPos spawnAreaEnd, int sizeX, int sizeZ, List<JsonElement> lootTables, CompoundTag chunkTemplates) {
        this.name = name;
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.spawnAreaStart = spawnAreaStart;
        this.spawnAreaEnd = spawnAreaEnd;
        this.treasuresMap = new HashMap<BlockPos, RaidTreasureType>();
        this.chunkTemplates = new ArrayList<CompoundTag>();
        lootTables.forEach(lootTableInfo -> {
            JsonObject object = lootTableInfo.getAsJsonObject();
            this.treasuresMap.put(new BlockPos(DataUtils.getValue(object, "x", 0), DataUtils.getValue(object, "y", 0), DataUtils.getValue(object, "z", 0)), RaidTreasureType.getType(DataUtils.getValue(object, "loot_table", "")));
        });
    }

    public RaidTreasureType getTreasureType(BlockPos pos) {
        return this.treasuresMap.get(pos);
    }

    public void setTreasureType(BlockPos pos, String type) {
        if (RaidTreasureType.getType(type) != null) {
            this.treasuresMap.put(pos, RaidTreasureType.getType(type));
        } else {
            FreeEpicGames.LOGGER.error("Invalid treasure loot table : {}", (Object)type);
        }
    }

    public RaidInstanceView create() {
        GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
        return agent.createRaidInstance(this);
    }

    public void updateConstruct(ChunkPos startChunk, ChunkPos endChunk) {
        this.chunkTemplates.clear();
        int targetZ = endChunk.f_45579_;
        for (int targetX = startChunk.f_45578_; targetX <= endChunk.f_45578_; ++targetX) {
            while (targetZ <= endChunk.f_45579_) {
                int offsetX = targetX - startChunk.f_45578_;
                int offsetZ = targetZ - startChunk.f_45579_;
                this.chunkTemplates.add(ChunkSerializer.m_63454_((ServerLevel)FreeEpicGames.RAID_WORLD, (ChunkAccess)FreeEpicGames.RAID_WORLD.m_6325_(offsetX, offsetZ)));
                ++targetZ;
            }
            targetZ = startChunk.f_45579_;
        }
    }

    public void updateConstruct(RaidInstanceView view) {
        this.chunkTemplates.clear();
        int targetZ = view.getStartChunk().f_45579_;
        for (int targetX = view.getStartChunk().f_45578_; targetX <= view.getEndChunk().f_45578_; ++targetX) {
            while (targetZ <= view.getEndChunk().f_45579_) {
                int offsetX = targetX - view.getStartChunk().f_45578_;
                int offsetZ = targetZ - view.getStartChunk().f_45579_;
                this.chunkTemplates.add(ChunkSerializer.m_63454_((ServerLevel)FreeEpicGames.RAID_WORLD, (ChunkAccess)FreeEpicGames.RAID_WORLD.m_6325_(offsetX, offsetZ)));
                ++targetZ;
            }
            targetZ = view.getStartChunk().f_45579_;
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("respawn_area_start_x", (Number)this.spawnAreaStart.m_123341_());
        jsonObject.addProperty("respawn_area_start_y", (Number)this.spawnAreaStart.m_123342_());
        jsonObject.addProperty("respawn_area_start_z", (Number)this.spawnAreaStart.m_123343_());
        jsonObject.addProperty("respawn_area_end_x", (Number)this.spawnAreaEnd.m_123341_());
        jsonObject.addProperty("respawn_area_end_y", (Number)this.spawnAreaEnd.m_123342_());
        jsonObject.addProperty("respawn_area_end_z", (Number)this.spawnAreaEnd.m_123343_());
        jsonObject.addProperty("chunk_size_x", (Number)this.sizeX);
        jsonObject.addProperty("chunk_size_y", (Number)this.sizeZ);
        JsonArray array = new JsonArray();
        this.treasuresMap.forEach((pos, type) -> {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)pos.m_123341_());
            object.addProperty("y", (Number)pos.m_123342_());
            object.addProperty("z", (Number)pos.m_123343_());
            object.addProperty("type", type.getName());
            array.add((JsonElement)object);
        });
        jsonObject.add("treasure_info", (JsonElement)new JsonArray());
        try {
            CompoundTag tag = new CompoundTag();
            ListTag chunks = new ListTag();
            chunks.addAll(this.chunkTemplates);
            tag.m_128365_("chunks", (Tag)chunks);
            IOUtilities.writeNbtCompressed(tag, FreeEpicGamesPaths.RAID_TEMPLATE_DIR.resolve(this.name + ".nbt"));
        }
        catch (IOException e) {
            FreeEpicGames.LOGGER.error("Failed to write raid template: {}", (Object)(this.name + ".nbt"));
        }
        return jsonObject;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            try {
                types.put(name, new RaidType(name, new BlockPos(DataUtils.getValue(object, "respawn_area_start_x", 0), DataUtils.getValue(object, "respawn_area_start_y", 0), DataUtils.getValue(object, "respawn_area_start_z", 0)), new BlockPos(DataUtils.getValue(object, "respawn_area_end_x", 0), DataUtils.getValue(object, "respawn_area_end_y", 0), DataUtils.getValue(object, "respawn_area_end_z", 0)), DataUtils.getValue(object, "chunk_size_x", 0), DataUtils.getValue(object, "chunk_size_z", 0), DataUtils.getValue(object, "treasure_info", new ArrayList<JsonElement>()), NbtIo.m_128953_((File)FreeEpicGamesPaths.RAID_TEMPLATE_DIR.resolve(name + ".nbt").toFile())));
            }
            catch (IOException e) {
                FreeEpicGames.LOGGER.error("Failed to read raid template: {}", (Object)(name + ".nbt"));
            }
            return true;
        }
        FreeEpicGames.LOGGER.error("Repeated registration key : {}", (Object)name);
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            return true;
        }
        return false;
    }

    public static List<RaidType> getAllType() {
        return new ArrayList<RaidType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static RaidType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Registering RaidTypes...");
        DataUtils.getPackAllData(DataPacket.RAID_TEMPLATE).forEach(RaidType::register);
        FreeEpicGames.LOGGER.info("Registered {} RaidTypes.", (Object)types.size());
    }

    public static void expire() {
        FreeEpicGames.LOGGER.info("Saving RaidTypes...");
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
        DataUtils.savePacketAllData(DataPacket.RAID_TEMPLATE, jsonMap);
        FreeEpicGames.LOGGER.info("Expiring RaidTypes...");
        types.clear();
        FreeEpicGames.LOGGER.info("Expired RaidTypes.");
    }

    public String getName() {
        return this.name;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public BlockPos getSpawnAreaStart() {
        return this.spawnAreaStart;
    }

    public BlockPos getSpawnAreaEnd() {
        return this.spawnAreaEnd;
    }

    public List<CompoundTag> getChunkTemplates() {
        return this.chunkTemplates;
    }
}

