/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.untils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesPaths;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.freeepicgames.database.untils.DataPacket;
import org.thexeler.freeepicgames.database.view.AbstractCacheView;
import org.thexeler.freeepicgames.database.view.AbstractView;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;

public class DataUtils {
    public static <T> Tag encodeForTag(Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).getOrThrow(false, msg -> FreeEpicGames.LOGGER.error("Can not encode to tag : {}", msg));
    }

    public static <T> JsonElement encodeForJson(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow(false, msg -> FreeEpicGames.LOGGER.error("Can not encode to json : {}", msg));
    }

    public static <T> T decode(Codec<T> codec, Tag tag) {
        return (T)codec.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).getOrThrow(false, msg -> FreeEpicGames.LOGGER.error("Can not decode from tag : {}", msg));
    }

    public static <T> T decode(Codec<T> codec, JsonElement tag) {
        return (T)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)tag).getOrThrow(false, msg -> FreeEpicGames.LOGGER.error("Can not decode from json : {}", msg));
    }

    public static String getValue(JsonObject jsonObject, String key, String defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, defaultValue);
        }
        return jsonObject.get(key).getAsString();
    }

    public static int getValue(JsonObject jsonObject, String key, int defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, (Number)defaultValue);
        }
        return jsonObject.get(key).getAsInt();
    }

    public static float getValue(JsonObject jsonObject, String key, float defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, (Number)Float.valueOf(defaultValue));
        }
        return jsonObject.get(key).getAsFloat();
    }

    public static double getValue(JsonObject jsonObject, String key, double defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, (Number)defaultValue);
        }
        return jsonObject.get(key).getAsDouble();
    }

    public static boolean getValue(JsonObject jsonObject, String key, boolean defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, Boolean.valueOf(defaultValue));
        }
        return jsonObject.get(key).getAsBoolean();
    }

    public static JsonObject getValue(JsonObject jsonObject, String key, JsonObject defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.add(key, (JsonElement)defaultValue);
        }
        return jsonObject.get(key).getAsJsonObject();
    }

    public static JsonArray getValue(JsonObject jsonObject, String key, JsonArray defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.add(key, (JsonElement)defaultValue);
        }
        return jsonObject.get(key).getAsJsonArray();
    }

    public static Map<String, JsonElement> getValue(JsonObject jsonObject, String key, Map<String, JsonElement> defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.add(key, (JsonElement)new JsonObject());
            defaultValue.forEach((s, element) -> jsonObject.get(key).getAsJsonObject().add(s, element));
        }
        return jsonObject.get(key).getAsJsonObject().asMap();
    }

    public static List<JsonElement> getValue(JsonObject jsonObject, String key, List<JsonElement> defaultValue) {
        if (jsonObject.get(key) == null) {
            jsonObject.add(key, (JsonElement)new JsonArray());
            defaultValue.forEach(element -> jsonObject.get(key).getAsJsonArray().add(element));
        }
        return jsonObject.get(key).getAsJsonArray().asList();
    }

    public static void computeViewMap(Map<String, ? extends AbstractView> views, JsonObject json) {
        DataUtils.clearDeprecatedKey(json, views);
        views.forEach((key, view) -> json.add(key, (JsonElement)view.toJson()));
    }

    public static void computeCacheViewMap(Map<String, ? extends AbstractCacheView> views, JsonObject json) {
        DataUtils.clearDeprecatedKey(json, views);
        views.forEach((key, view) -> json.add(key, (JsonElement)view.toCacheJson()));
    }

    public static void clearDeprecatedKey(JsonObject json, Map<String, ?> values) {
        json.asMap().forEach((key, value) -> {
            if (!values.containsKey(key)) {
                json.remove(key);
            }
        });
    }

    public static JsonArray fromContainer(Container container) {
        JsonArray array = new JsonArray();
        for (int i = 0; i < container.m_6643_(); ++i) {
            array.add((JsonElement)DataUtils.fromItemStack(container.m_8020_(i)));
        }
        return array;
    }

    public static Container toContainer(JsonArray json, Container container) {
        for (int i = 0; i < json.size(); ++i) {
            ItemStack itemStack = DataUtils.toItemStack(json.get(i).getAsJsonObject());
            if (itemStack.m_41619_()) continue;
            container.m_6836_(i, itemStack);
        }
        return container;
    }

    public static Container toContainer(JsonArray json) {
        SimpleContainer container = new SimpleContainer(27);
        return DataUtils.toContainer(json, (Container)container);
    }

    public static JsonObject fromItemStack(ItemStack itemStack) {
        return DataUtils.fromItemStack(itemStack.m_41720_(), itemStack.m_41613_(), itemStack.serializeNBT());
    }

    public static JsonObject fromItemStack(Item item, int count, CompoundTag patch) {
        JsonObject json = new JsonObject();
        json.addProperty("id", item.toString());
        json.addProperty("count", (Number)count);
        json.add("nbt", DataUtils.encodeForJson(CompoundTag.f_128325_, patch));
        return json;
    }

    public static ItemStack toItemStack(JsonObject json) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("id").getAsString()));
        ItemStack itemStack = null;
        if (item instanceof AirItem || item == null) {
            FreeEpicGames.LOGGER.warn("Item not found: {}", (Object)json.get("id").getAsString());
        } else {
            itemStack = new ItemStack((ItemLike)item, json.get("count").getAsInt());
            itemStack.deserializeNBT((CompoundTag)DataUtils.decode(CompoundTag.f_128325_, json.get("nbt")));
        }
        return itemStack;
    }

    public static ItemStack toItemStack(Item item, int count, CompoundTag patch) {
        ItemStack itemStack = new ItemStack((ItemLike)item, count);
        itemStack.deserializeNBT(patch);
        return itemStack;
    }

    public static Map<String, JsonObject> getPackAllData(DataPacket type) {
        Path dir = DataPacket.getDirectory(type);
        final HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                String prefix = "";

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) throws IOException {
                    if (Files.isHidden(dir) || Files.isSymbolicLink(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    this.prefix = this.prefix + dir.getFileName().toString() + ".";
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                    if (file.endsWith(".json")) {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        try (BufferedReader reader = new BufferedReader(new FileReader(file.toFile()));){
                            JsonObject object = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                            String filePath = file.getFileName().toString();
                            jsonMap.put(this.prefix + filePath.substring(0, filePath.lastIndexOf(46)), object);
                        }
                        catch (IOException e) {
                            FreeEpicGames.LOGGER.error(e.getMessage());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                    this.prefix = this.prefix.substring(0, this.prefix.lastIndexOf(46, this.prefix.length() - 2) + 1);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            FreeEpicGames.LOGGER.error(e.getMessage());
        }
        return jsonMap;
    }

    public static void savePacketAllData(DataPacket type, Map<String, JsonObject> jsonMap) {
        Path dir = DataPacket.getDirectory(type);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonMap.forEach((key, jsonObject) -> {
            try {
                String[] parts = key.split("\\.");
                Path filePath = dir;
                for (String part : parts) {
                    filePath = filePath.resolve(part);
                }
                filePath = FreeEpicGamesPaths.makeSureExist(filePath.getParent().resolve(filePath.getFileName() + ".json"));
                try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                    writer.write(gson.toJson((JsonElement)jsonObject));
                }
            }
            catch (IOException e) {
                FreeEpicGames.LOGGER.error(e.getMessage());
            }
        });
    }

    public static boolean isChunkEmpty(int chunkPosX, int chunkPosZ) {
        boolean flag = true;
        for (RaidInstanceView view : GlobalRaidDataAgent.getInstance().getAllRaidInstance()) {
            if (!view.isInside(new Vec3((double)(chunkPosX * 16 - 8), 0.0, (double)(chunkPosZ * 16 - 8)))) continue;
            flag = false;
            break;
        }
        return flag;
    }
}

