/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.untils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.agent.GlobalJobDataAgent;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.slacker.mojang.level.CompatSavedData;

public class ModSavedData
extends CompatSavedData {
    private static ModSavedData instance = null;
    private final Map<String, JsonObject> globalDataMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, JsonObject>> worldDataMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, AbstractDataAgent> worldAgentMap = Collections.synchronizedMap(new HashMap());

    private ModSavedData() {
        instance = this;
    }

    public static JsonObject getGlobalData(String id) {
        return ModSavedData.instance.globalDataMap.computeIfAbsent(id, key -> new JsonObject());
    }

    public static JsonObject getWorldData(Level world, String id) {
        return ModSavedData.instance.worldDataMap.computeIfAbsent(world.m_46472_().toString(), key -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(id, key -> new JsonObject());
    }

    public static ModSavedData load(CompoundTag compoundTag) {
        Gson gson = new Gson();
        ModSavedData savedData = new ModSavedData();
        CompoundTag globalTag = compoundTag.m_128469_("Global");
        CompoundTag worldsTag = compoundTag.m_128469_("Worlds");
        if (!globalTag.m_128456_()) {
            globalTag.m_128431_().forEach(key -> savedData.globalDataMap.put((String)key, (JsonObject)gson.fromJson(globalTag.m_128423_(key).m_7916_(), JsonObject.class)));
        }
        if (!worldsTag.m_128456_()) {
            worldsTag.m_128431_().forEach(key -> {
                Map worldData = savedData.worldDataMap.computeIfAbsent((String)key, k -> new HashMap());
                CompoundTag worldTag = worldsTag.m_128469_(key);
                if (!worldTag.m_128456_()) {
                    worldTag.m_128431_().forEach(key2 -> worldData.put(key2, (JsonObject)gson.fromJson(worldTag.m_128423_(key2).m_7916_(), JsonObject.class)));
                }
                savedData.worldDataMap.put((String)key, worldData);
            });
        }
        return savedData;
    }

    public static ModSavedData load(CompoundTag compoundTag, HolderLookup.Provider lookupProvider) {
        Gson gson = new Gson();
        ModSavedData savedData = new ModSavedData();
        CompoundTag globalTag = compoundTag.m_128469_("Global");
        CompoundTag worldsTag = compoundTag.m_128469_("Worlds");
        if (!globalTag.m_128456_()) {
            globalTag.m_128431_().forEach(key -> savedData.globalDataMap.put((String)key, (JsonObject)gson.fromJson(globalTag.m_128423_(key).m_7916_(), JsonObject.class)));
        }
        if (!worldsTag.m_128456_()) {
            worldsTag.m_128431_().forEach(key -> {
                Map worldData = savedData.worldDataMap.computeIfAbsent((String)key, k -> new HashMap());
                CompoundTag worldTag = worldsTag.m_128469_(key);
                if (!worldTag.m_128456_()) {
                    worldTag.m_128431_().forEach(key2 -> worldData.put(key2, (JsonObject)gson.fromJson(worldTag.m_128423_(key2).m_7916_(), JsonObject.class)));
                }
                savedData.worldDataMap.put((String)key, worldData);
            });
        }
        return savedData;
    }

    @Override
    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        GlobalJobDataAgent.getInstance().save();
        GlobalRaidDataAgent.getInstance().save();
        this.worldAgentMap.forEach((key, value) -> value.save());
        Gson gson = new Gson();
        CompoundTag globalTag = new CompoundTag();
        CompoundTag worldsTag = new CompoundTag();
        this.globalDataMap.forEach((key, value) -> globalTag.m_128365_(key, (Tag)StringTag.m_129297_((String)gson.toJson((JsonElement)value))));
        this.worldDataMap.forEach((key, value) -> {
            CompoundTag worldTag = new CompoundTag();
            value.forEach((key2, value2) -> worldTag.m_128365_(key2, (Tag)StringTag.m_129297_((String)gson.toJson((JsonElement)value2))));
            worldsTag.m_128365_(key, (Tag)worldTag);
        });
        compoundTag.m_128365_("Global", (Tag)globalTag);
        compoundTag.m_128365_("Worlds", (Tag)worldsTag);
        return compoundTag;
    }

    public boolean m_77764_() {
        return true;
    }

    public static ModSavedData create() {
        return new ModSavedData();
    }
}

