/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.thexeler.freeepicgames.database.agent.WorldCaptureDataAgent;
import org.thexeler.freeepicgames.database.untils.LogicTeam;
import org.thexeler.freeepicgames.database.view.AbstractCacheView;
import org.thexeler.freeepicgames.database.view.AbstractView;

public class AreaView
implements AbstractView,
AbstractCacheView {
    private final WorldCaptureDataAgent rootAgent;
    private final String name;
    private final Vec3 pos;
    private final Vec3 end;
    private final ServerBossEvent bossBar;
    private float schedule;
    private LogicTeam controller;
    private boolean locked;
    private boolean exportSchedule;
    private boolean exportScheduleFormat;
    private List<String> lockWhenAttackerCapture;
    private List<String> unlockWhenAttackerCapture;
    private List<String> lockWhenDefenderCapture;
    private List<String> unlockWhenDefenderCapture;
    private final AABB frame;

    public AreaView(String name, JsonObject areaInfo, WorldCaptureDataAgent agent) {
        this.name = name;
        this.rootAgent = agent;
        this.pos = new Vec3(areaInfo.get("posX").getAsDouble(), areaInfo.get("posY").getAsDouble(), areaInfo.get("posZ").getAsDouble());
        this.end = new Vec3(areaInfo.get("endX").getAsDouble(), areaInfo.get("endY").getAsDouble(), areaInfo.get("endZ").getAsDouble());
        this.lockWhenAttackerCapture = areaInfo.get("lockWhenAttackerCapture").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        this.unlockWhenAttackerCapture = areaInfo.get("unlockWhenAttackerCapture").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        this.lockWhenDefenderCapture = areaInfo.get("lockWhenDefenderCapture").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        this.unlockWhenDefenderCapture = areaInfo.get("unlockWhenDefenderCapture").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        this.locked = false;
        this.schedule = 0.0f;
        this.exportSchedule = false;
        this.exportScheduleFormat = false;
        this.controller = LogicTeam.NEUTRAL;
        this.frame = new AABB(this.pos, this.end);
        this.bossBar = new ServerBossEvent((Component)Component.m_237113_((String)name), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossBar.m_142711_(Math.abs(this.schedule / 2.0f));
        this.bossBar.m_8321_(true);
    }

    public boolean isInside(Vec3 pos) {
        return this.frame.m_82390_(pos);
    }

    public void setSchedule(float num) {
        this.schedule = Mth.m_14036_((float)num, (float)-100.0f, (float)100.0f);
        this.bossBar.m_142711_(Mth.m_14036_((float)((this.schedule + 100.0f) / 200.0f), (float)0.0f, (float)1.0f));
    }

    public void setController(LogicTeam team) {
        this.controller = team;
        this.bossBar.m_6451_(switch (this.controller) {
            case LogicTeam.ATTACKER -> BossEvent.BossBarColor.RED;
            case LogicTeam.DEFENDER -> BossEvent.BossBarColor.BLUE;
            default -> BossEvent.BossBarColor.WHITE;
        });
        if (team == LogicTeam.ATTACKER) {
            this.lockWhenAttackerCapture.forEach(name -> {
                AreaView area = this.rootAgent.getAreaView((String)name);
                if (area != null) {
                    area.setLocked(true);
                }
            });
            this.unlockWhenAttackerCapture.forEach(name -> {
                AreaView area = this.rootAgent.getAreaView((String)name);
                if (area != null) {
                    area.setLocked(true);
                }
            });
        } else if (team == LogicTeam.DEFENDER) {
            this.lockWhenDefenderCapture.forEach(name -> {
                AreaView area = this.rootAgent.getAreaView((String)name);
                if (area != null) {
                    area.setLocked(true);
                }
            });
            this.unlockWhenDefenderCapture.forEach(name -> {
                AreaView area = this.rootAgent.getAreaView((String)name);
                if (area != null) {
                    area.setLocked(true);
                }
            });
        }
    }

    public void loadStatus(JsonObject cacheInfo) {
        this.locked = cacheInfo.get("locked").getAsBoolean();
        this.schedule = cacheInfo.get("schedule").getAsFloat();
        this.controller = LogicTeam.fromString(cacheInfo.get("controller").getAsString());
        this.exportSchedule = cacheInfo.get("exportSchedule").getAsBoolean();
        this.exportScheduleFormat = cacheInfo.get("exportScheduleFormat").getAsBoolean();
    }

    @Override
    public JsonObject toCacheJson() {
        JsonObject cacheInfo = new JsonObject();
        cacheInfo.addProperty("locked", Boolean.valueOf(this.locked));
        cacheInfo.addProperty("schedule", (Number)Float.valueOf(this.schedule));
        cacheInfo.addProperty("controller", this.controller.toString());
        cacheInfo.addProperty("exportSchedule", Boolean.valueOf(this.exportSchedule));
        cacheInfo.addProperty("exportScheduleFormat", Boolean.valueOf(this.exportScheduleFormat));
        return cacheInfo;
    }

    @Override
    public JsonObject toJson() {
        JsonObject areaInfo = new JsonObject();
        areaInfo.addProperty("posX", (Number)this.pos.f_82479_);
        areaInfo.addProperty("posY", (Number)this.pos.f_82480_);
        areaInfo.addProperty("posZ", (Number)this.pos.f_82481_);
        areaInfo.addProperty("endX", (Number)this.end.f_82479_);
        areaInfo.addProperty("endY", (Number)this.end.f_82480_);
        areaInfo.addProperty("endZ", (Number)this.end.f_82481_);
        JsonArray attackerCaptureLocks = new JsonArray();
        JsonArray attackerCaptureUnlocks = new JsonArray();
        JsonArray defenderCaptureLocks = new JsonArray();
        JsonArray defenderCaptureUnlocks = new JsonArray();
        this.lockWhenAttackerCapture.forEach(arg_0 -> ((JsonArray)attackerCaptureLocks).add(arg_0));
        this.unlockWhenAttackerCapture.forEach(arg_0 -> ((JsonArray)attackerCaptureUnlocks).add(arg_0));
        this.lockWhenDefenderCapture.forEach(arg_0 -> ((JsonArray)defenderCaptureLocks).add(arg_0));
        this.unlockWhenDefenderCapture.forEach(arg_0 -> ((JsonArray)defenderCaptureUnlocks).add(arg_0));
        areaInfo.add("lockWhenAttackerCapture", (JsonElement)attackerCaptureLocks);
        areaInfo.add("unlockWhenAttackerCapture", (JsonElement)attackerCaptureUnlocks);
        areaInfo.add("lockWhenDefenderCapture", (JsonElement)defenderCaptureLocks);
        areaInfo.add("unlockWhenDefenderCapture", (JsonElement)defenderCaptureUnlocks);
        return areaInfo;
    }

    public String getName() {
        return this.name;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public Vec3 getEnd() {
        return this.end;
    }

    public ServerBossEvent getBossBar() {
        return this.bossBar;
    }

    public float getSchedule() {
        return this.schedule;
    }

    public LogicTeam getController() {
        return this.controller;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isExportSchedule() {
        return this.exportSchedule;
    }

    public boolean isExportScheduleFormat() {
        return this.exportScheduleFormat;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setExportSchedule(boolean exportSchedule) {
        this.exportSchedule = exportSchedule;
    }

    public void setExportScheduleFormat(boolean exportScheduleFormat) {
        this.exportScheduleFormat = exportScheduleFormat;
    }

    public void setLockWhenAttackerCapture(List<String> lockWhenAttackerCapture) {
        this.lockWhenAttackerCapture = lockWhenAttackerCapture;
    }

    public void setUnlockWhenAttackerCapture(List<String> unlockWhenAttackerCapture) {
        this.unlockWhenAttackerCapture = unlockWhenAttackerCapture;
    }

    public void setLockWhenDefenderCapture(List<String> lockWhenDefenderCapture) {
        this.lockWhenDefenderCapture = lockWhenDefenderCapture;
    }

    public void setUnlockWhenDefenderCapture(List<String> unlockWhenDefenderCapture) {
        this.unlockWhenDefenderCapture = unlockWhenDefenderCapture;
    }
}

