/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.view;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.database.agent.WorldNpcDataAgent;
import org.thexeler.freeepicgames.database.type.NpcType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.AbstractView;
import org.thexeler.mind.MindMachine;

public class NpcView
implements AbstractView {
    private final WorldNpcDataAgent rootAgent;
    private final String id;
    private final NpcType npcType;
    private final Entity originEntity;
    private final HashMap<String, String> npcData;
    private final MindMachine mind;

    public NpcView(@NotNull Entity origin, NpcType type, WorldNpcDataAgent agent) {
        this.rootAgent = agent;
        this.originEntity = origin;
        this.id = origin.m_20149_();
        this.npcType = type;
        this.npcData = new HashMap();
        this.mind = new MindMachine(origin);
    }

    public NpcView(JsonObject object, WorldNpcDataAgent agent) {
        this.rootAgent = agent;
        this.id = DataUtils.getValue(object, "id", "");
        this.npcType = NpcType.getType(DataUtils.getValue(object, "type", ""));
        this.originEntity = agent.getWorld().m_8791_(UUID.fromString(this.id));
        this.npcData = new HashMap();
        this.mind = new MindMachine(this.originEntity);
    }

    public void discard() {
        this.discardAdditional();
        if (this.originEntity != null) {
            this.originEntity.m_146870_();
        }
    }

    public void discardAdditional() {
        this.rootAgent.deleteNpc(this.id);
    }

    public static NpcView getEntity(Entity entity) {
        Level level;
        if (entity != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            return NpcView.getEntity(level2, entity.m_20149_());
        }
        return null;
    }

    public static NpcView getEntity(ServerLevel level, UUID uuid) {
        return NpcView.getEntity(level, uuid.toString());
    }

    public static NpcView getEntity(ServerLevel level, String id) {
        return WorldNpcDataAgent.getInstance(level).getNpcView(id);
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", this.id);
        jsonObject.addProperty("type", this.npcType.getName());
        JsonObject npcDataJson = new JsonObject();
        this.npcData.forEach((arg_0, arg_1) -> ((JsonObject)npcDataJson).addProperty(arg_0, arg_1));
        jsonObject.add("npc_data", (JsonElement)npcDataJson);
        return jsonObject;
    }

    public String getId() {
        return this.id;
    }

    public NpcType getNpcType() {
        return this.npcType;
    }

    public Entity getOriginEntity() {
        return this.originEntity;
    }

    public HashMap<String, String> getNpcData() {
        return this.npcData;
    }

    public MindMachine getMind() {
        return this.mind;
    }
}

