/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.database.agent.WorldCaptureDataAgent;
import org.thexeler.freeepicgames.database.untils.LogicTeam;
import org.thexeler.freeepicgames.database.view.AreaView;

public class CaptureEventHandler {
    private int tickCount = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (FreeEpicGamesConfigs.isEnabledCapture) {
            ++this.tickCount;
            if (this.tickCount % FreeEpicGamesConfigs.captureTick == 0) {
                this.tickCount -= FreeEpicGamesConfigs.captureTick;
                event.getServer().m_129785_().forEach(serverLevel -> {
                    WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(serverLevel);
                    String attackerName = agent.getAttacker();
                    String defenderName = agent.getDefender();
                    agent.getAllAreas().stream().filter(AreaView::isLocked).forEach(area -> {
                        float areaSchedule = area.getSchedule();
                        AtomicInteger scheduleCount = new AtomicInteger();
                        LogicTeam controller = area.getController();
                        ServerBossEvent bossBar = area.getBossBar();
                        PlayerTeam attacker = serverLevel.m_7654_().m_129896_().m_83489_(attackerName);
                        PlayerTeam defender = serverLevel.m_7654_().m_129896_().m_83489_(defenderName);
                        serverLevel.m_6907_().forEach(player -> {
                            if (area.isInside(player.m_20182_())) {
                                if (attacker != null && attacker.m_6809_().contains(player.m_7755_().getString())) {
                                    scheduleCount.getAndIncrement();
                                }
                                if (defender != null && defender.m_6809_().contains(player.m_7755_().getString())) {
                                    scheduleCount.getAndDecrement();
                                }
                                bossBar.m_6543_(player);
                            } else {
                                bossBar.m_6539_(player);
                            }
                        });
                        if (scheduleCount.get() != 0) {
                            area.setSchedule((float)scheduleCount.get() * agent.getRate() + area.getSchedule());
                        }
                        if (areaSchedule >= 100.0f) {
                            if (controller != LogicTeam.ATTACKER) {
                                serverLevel.m_6907_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)("\u8fdb\u653b\u65b9\u5df2\u593a\u53d6\u533a\u57df" + area.getName() + "!"))));
                                area.setController(LogicTeam.ATTACKER);
                            }
                        } else if (areaSchedule <= -100.0f) {
                            if (controller != LogicTeam.DEFENDER) {
                                serverLevel.m_6907_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)("\u9632\u5b88\u65b9\u5df2\u593a\u53d6\u533a\u57df" + area.getName() + "!"))));
                                area.setController(LogicTeam.DEFENDER);
                            }
                        } else if (areaSchedule <= 50.0f && controller == LogicTeam.ATTACKER || areaSchedule >= -50.0f && controller == LogicTeam.DEFENDER) {
                            serverLevel.m_6907_().forEach(player -> {
                                String string = area.getName();
                                player.m_213846_((Component)Component.m_237113_((String)("\u533a\u57df" + string + "\u5df2\u88ab" + (switch (controller) {
                                    case LogicTeam.ATTACKER -> "\u9632\u5b88\u65b9";
                                    case LogicTeam.DEFENDER -> "\u8fdb\u653b\u65b9";
                                    default -> "";
                                }) + "\u4e2d\u7acb\u5316!")));
                            });
                            area.setController(LogicTeam.NEUTRAL);
                        }
                    });
                });
            }
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SpectralArrow) {
            SpectralArrow arrow = (SpectralArrow)projectile;
            try (Level world = arrow.m_9236_();){
                if (world.m_5776_()) {
                    return;
                }
                if (arrow.m_19749_() == null) {
                    return;
                }
                WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance((ServerLevel)world);
                EntityType cannonType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("createbigcannons", "drop_mortar_shell"));
                String uuid = arrow.m_19749_().m_20149_();
                if (uuid.equals(agent.getAttackerCommander()) || uuid.equals(agent.getDefenderCommander())) {
                    Random random = new Random();
                    this.createCannonShell(cannonType, world, arrow.m_146903_(), (double)arrow.m_146904_() + 100.0, arrow.m_146907_());
                    int i = 0;
                    while (i++ < 80) {
                        this.createCannonShell(cannonType, world, (double)arrow.m_146903_() + random.nextDouble(-20.0, 20.0), (double)arrow.m_146904_() + 300.0 + (double)i * 20.0, (double)arrow.m_146907_() + random.nextDouble(-20.0, 20.0));
                    }
                    arrow.m_146870_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Entity createCannonShell(EntityType<?> cannonType, Level world, double x, double y, double z) {
        Entity entity = cannonType.m_20615_(world);
        if (entity != null) {
            CompoundTag fuze = new CompoundTag();
            fuze.m_128405_("Count", 1);
            fuze.m_128359_("id", "createbigcannons:impact_fuze");
            entity.getPersistentData().m_128365_("Fuze", (Tag)fuze);
            entity.m_6034_(x, y, z);
            world.m_7967_(entity);
        } else {
            FreeEpicGames.LOGGER.error("Can not create entity by type \"{}\" !", cannonType);
        }
        return entity;
    }
}

