/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.thexeler.freeepicgames.database.agent.WorldNpcDataAgent;
import org.thexeler.freeepicgames.database.view.NpcView;
import org.thexeler.freeepicgames.events.NpcEvent;
import org.thexeler.slacker.SlackerForge;

public class NpcEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeath(LivingDeathEvent event) {
        NpcView view;
        NpcEvent.KilledEvent npcEvent;
        NpcView source = NpcView.getEntity(event.getSource().m_7639_());
        if (source != null && SlackerForge.EVENT_BUS.post(npcEvent = new NpcEvent.KilledEvent(source, (Entity)event.getEntity(), event.getSource())).isCanceled()) {
            event.setCanceled(true);
            event.getEntity().m_21153_(1.0f);
        }
        if ((view = NpcView.getEntity((Entity)event.getEntity())) != null) {
            NpcEvent.DeathEvent npcEvent2 = new NpcEvent.DeathEvent(view, event.getSource());
            if (!SlackerForge.EVENT_BUS.post(npcEvent2).isCanceled()) {
                view.discard();
            } else {
                event.setCanceled(true);
                Entity entity = view.getOriginEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity entity2 = (LivingEntity)entity;
                    entity2.m_21153_(1.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        NpcView entity = NpcView.getEntity(event.getTarget());
        if (entity != null) {
            MinecraftForge.EVENT_BUS.post((Event)new NpcEvent.InteractEvent(entity, event.getEntity()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDamage(LivingDamageEvent event) {
        NpcView entity;
        NpcView source = NpcView.getEntity(event.getSource().m_7639_());
        if (source != null) {
            NpcEvent.MeleeAttackEvent npcEvent = new NpcEvent.MeleeAttackEvent(source, (Entity)event.getEntity(), event.getSource(), event.getAmount());
            MinecraftForge.EVENT_BUS.post((Event)npcEvent);
            event.setAmount(npcEvent.getAmount());
        }
        if ((entity = NpcView.getEntity((Entity)event.getEntity())) != null) {
            NpcEvent.DamageEvent npcEvent = new NpcEvent.DamageEvent(entity, event.getSource(), event.getAmount());
            if (!MinecraftForge.EVENT_BUS.post((Event)npcEvent)) {
                event.setAmount(npcEvent.getAmount());
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityTick(TickEvent.ServerTickEvent event) {
        event.getServer().m_129785_().forEach(serverLevel -> {
            WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(serverLevel);
            agent.getAllNpc().forEach(entity -> {
                if (entity.getNpcType().isWeakAI()) {
                    entity.getMind().tick();
                }
                MinecraftForge.EVENT_BUS.post((Event)new NpcEvent.TickEvent((NpcView)entity));
            });
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onProjectileFire(EntityJoinLevelEvent event) {
        Projectile projectile;
        NpcView view;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile && (view = NpcView.getEntity((projectile = (Projectile)entity).m_19749_())) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new NpcEvent.RangeAttack.FireEvent(view, projectile));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onProjectileImpact(ProjectileImpactEvent event) {
        NpcView view;
        Entity entity = event.getProjectile().m_19749_();
        if (entity != null && (view = NpcView.getEntity(entity)) != null) {
            NpcEvent.RangeAttack.HitEvent npcEvent = new NpcEvent.RangeAttack.HitEvent(view, event.getProjectile(), event.getRayTraceResult(), event.getEntity());
            SlackerForge.EVENT_BUS.post(npcEvent);
        }
    }
}

