/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.mind.intention;

import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import org.thexeler.mind.intention.IntentionPriority;
import org.thexeler.mind.intention.IntentionType;

public abstract class Intention {
    protected IntentionPriority priority;
    protected IntentionType type;
    protected final Entity origin;

    public Intention(Entity origin, IntentionType type) {
        this.type = type;
        this.origin = origin;
        this.priority = IntentionPriority.NORMAL;
    }

    public Intention(Entity origin, IntentionType type, IntentionPriority priority) {
        this.type = type;
        this.origin = origin;
        this.priority = priority;
    }

    public abstract boolean execute();

    public abstract void hold();

    public IntentionPriority getPriority() {
        return this.priority;
    }

    public IntentionType getType() {
        return this.type;
    }

    public Entity getOrigin() {
        return this.origin;
    }

    public static class RangeAttackIntention
    extends FollowIntention {
        protected BiConsumer<Entity, Entity> attackFunction;

        public RangeAttackIntention(Entity origin, Entity target, double distance, BiConsumer<Entity, Entity> attackFunction) {
            super(origin, target, distance, true);
            this.attackFunction = attackFunction;
        }

        public RangeAttackIntention(Entity origin, Entity target, double distance, BiConsumer<Entity, Entity> attackFunction, IntentionPriority priority) {
            super(origin, target, distance, true, priority);
            this.attackFunction = attackFunction;
        }

        @Override
        public boolean execute() {
            super.execute();
            if (this.target.m_6097_() && this.target.m_6084_()) {
                this.attackFunction.accept(this.origin, this.target);
                return this.target.m_6084_();
            }
            return true;
        }

        public void setAttackFunction(BiConsumer<Entity, Entity> attackFunction) {
            this.attackFunction = attackFunction;
        }
    }

    public static class MeleeAttackIntention
    extends FollowIntention {
        protected float damage;

        public MeleeAttackIntention(Entity origin, Entity target) {
            super(origin, target);
        }

        public MeleeAttackIntention(Entity origin, Entity target, IntentionPriority priority) {
            super(origin, target, priority);
        }

        @Override
        public boolean execute() {
            super.execute();
            if (this.target.m_6097_() && this.target.m_6084_()) {
                if (this.origin.m_20182_().m_82554_(this.target.m_20182_()) < this.distance) {
                    Entity entity = this.origin;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        this.target.m_6469_(this.origin.m_269291_().m_269333_(livingEntity), this.damage);
                    } else {
                        this.target.m_6469_(this.origin.m_269291_().m_269264_(), this.damage);
                    }
                }
                return this.target.m_6084_();
            }
            return true;
        }

        public float getDamage() {
            return this.damage;
        }

        public void setDamage(float damage) {
            this.damage = damage;
        }
    }

    public static class FollowIntention
    extends SimpleIntention {
        protected final Entity target;
        protected double distance;
        protected boolean forceDistance;

        public FollowIntention(Entity origin, Entity target) {
            super(origin, IntentionType.FOLLOW);
            this.target = target;
            this.distance = 0.1f;
            this.forceDistance = false;
        }

        public FollowIntention(Entity origin, Entity target, IntentionPriority priority) {
            super(origin, IntentionType.FOLLOW, priority);
            this.target = target;
            this.distance = 0.1f;
            this.forceDistance = false;
        }

        public FollowIntention(Entity origin, Entity target, double distance) {
            super(origin, IntentionType.FOLLOW);
            this.target = target;
            this.distance = distance;
            this.forceDistance = false;
        }

        public FollowIntention(Entity origin, Entity target, double distance, IntentionPriority priority) {
            super(origin, IntentionType.FOLLOW, priority);
            this.target = target;
            this.distance = distance;
            this.forceDistance = false;
        }

        public FollowIntention(Entity origin, Entity target, double distance, boolean forcedDistance) {
            super(origin, IntentionType.FOLLOW);
            this.target = target;
            this.distance = distance;
            this.forceDistance = forcedDistance;
        }

        public FollowIntention(Entity origin, Entity target, double distance, boolean forcedDistance, IntentionPriority priority) {
            super(origin, IntentionType.FOLLOW, priority);
            this.target = target;
            this.distance = distance;
            this.forceDistance = forcedDistance;
        }

        @Override
        public boolean execute() {
            Vec3 originPos = this.origin.m_20182_();
            Vec3 targetPos = this.target.m_20182_();
            double dx = targetPos.f_82479_ - originPos.f_82479_;
            double dy = targetPos.f_82480_ - originPos.f_82480_;
            double dz = targetPos.f_82481_ - originPos.f_82481_;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (this.distance != distance && (this.forceDistance || this.distance < distance)) {
                this.origin.m_6478_(MoverType.SELF, new Vec3(originPos.f_82479_ + dx * distance, originPos.f_82480_ + dy * distance, originPos.f_82481_ + dz * distance));
            }
            return false;
        }

        public Entity getTarget() {
            return this.target;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public boolean isForceDistance() {
            return this.forceDistance;
        }

        public void setForceDistance(boolean forceDistance) {
            this.forceDistance = forceDistance;
        }
    }

    public static class MoveIntention
    extends SimpleIntention {
        protected final Vec3 pos;

        public MoveIntention(Entity origin, Vec3 pos) {
            super(origin, IntentionType.MOVE);
            this.pos = pos;
        }

        public MoveIntention(Entity origin, Vec3 pos, IntentionPriority priority) {
            super(origin, IntentionType.MOVE, priority);
            this.pos = pos;
        }

        @Override
        public boolean execute() {
            if (this.origin.m_20182_().equals((Object)this.pos)) {
                return true;
            }
            this.origin.m_6478_(MoverType.SELF, this.pos.m_82546_(this.origin.m_20182_()));
            return false;
        }

        public Vec3 getPos() {
            return this.pos;
        }
    }

    public static abstract class SimpleIntention
    extends Intention {
        public SimpleIntention(Entity origin, IntentionType type) {
            super(origin, type);
        }

        public SimpleIntention(Entity origin, IntentionType type, IntentionPriority priority) {
            super(origin, type, priority);
        }

        @Override
        public void hold() {
        }
    }
}

