/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.slacker.utils;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.jetbrains.annotations.Nullable;

public final class IOUtilities {
    private static final String TEMP_FILE_SUFFIX = ".neoforge-tmp";
    private static final OpenOption[] OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};

    private IOUtilities() {
    }

    public static void cleanupTempFiles(Path targetPath, @Nullable String prefix) throws IOException {
        try (Stream<Path> filesToDelete = Files.find(targetPath, 1, IOUtilities.createPredicate(prefix), new FileVisitOption[0]);){
            for (Path file : filesToDelete.toList()) {
                Files.deleteIfExists(file);
            }
        }
    }

    private static BiPredicate<Path, BasicFileAttributes> createPredicate(@Nullable String prefix) {
        return (file, attributes) -> {
            String fileName = file.getFileName().toString();
            return fileName.endsWith(TEMP_FILE_SUFFIX) && (prefix == null || fileName.startsWith(prefix));
        };
    }

    public static void writeNbtCompressed(CompoundTag tag, Path path) throws IOException {
        IOUtilities.atomicWrite(path, stream -> {
            try (BufferedOutputStream bufferedStream = new BufferedOutputStream(stream);){
                NbtIo.m_128947_((CompoundTag)tag, (OutputStream)bufferedStream);
            }
        });
    }

    public static void writeNbt(CompoundTag tag, Path path) throws IOException {
        IOUtilities.atomicWrite(path, stream -> {
            try (BufferedOutputStream bufferedStream = new BufferedOutputStream(stream);
                 DataOutputStream dataStream = new DataOutputStream(bufferedStream);){
                NbtIo.m_128941_((CompoundTag)tag, (DataOutput)dataStream);
            }
        });
    }

    public static void atomicWrite(Path targetPath, WriteCallback writeCallback) throws IOException {
        Path tempPath = Files.createTempFile(targetPath.getParent(), targetPath.getFileName().toString(), TEMP_FILE_SUFFIX, new FileAttribute[0]);
        try {
            try (FileChannel channel = FileChannel.open(tempPath, OPEN_OPTIONS);){
                CloseShieldOutputStream stream = CloseShieldOutputStream.wrap((OutputStream)Channels.newOutputStream(channel));
                writeCallback.write((OutputStream)stream);
                channel.force(true);
            }
            try {
                Files.move(tempPath, targetPath, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception first) {
            try {
                Files.deleteIfExists(tempPath);
            }
            catch (Exception second) {
                first.addSuppressed(second);
            }
            throw first;
        }
    }

    public static interface WriteCallback {
        public void write(OutputStream var1) throws IOException;
    }
}

