/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command;

import net.minecraft.world.entity.Entity;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.command.lamp.actor.ForgeCommandActor;
import org.thexeler.freeepicgames.command.lamp.annotations.RequiresOP;
import org.thexeler.freeepicgames.command.lamp.annotations.WithNpc;
import org.thexeler.freeepicgames.command.lamp.annotations.WithNpcType;
import org.thexeler.freeepicgames.command.lamp.parameters.EntitySelectorList;
import org.thexeler.freeepicgames.database.agent.WorldNpcDataAgent;
import org.thexeler.freeepicgames.database.type.NpcType;
import org.thexeler.freeepicgames.database.view.NpcView;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;

@Command(value={"fegnpc"})
public class ModelNpcCommand {
    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"create <type>"})
    public void create(ForgeCommandActor sender, @WithNpcType String type) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        if (agent.createNpc(NpcType.getType(type)) != null) {
            sender.reply("\u6210\u529f\u521b\u5efaNPC");
        } else {
            sender.reply("\u521b\u5efa\u5931\u8d25");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"create <type> <selector>"})
    public void create(ForgeCommandActor sender, @WithNpcType String type, EntitySelectorList<Entity> selector) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            if (agent.createNpc(NpcType.getType(type), (Entity)entity) != null) {
                sender.reply("\u6210\u529f\u9644\u52a0NPC\u529f\u80fd\u5230\u5df2\u6709\u751f\u7269");
            } else {
                sender.reply("\u9644\u52a0\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"delete <id>"})
    public void delete(ForgeCommandActor sender, String id) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        NpcView npc = agent.getNpcView(id);
        if (npc != null) {
            npc.discard();
            sender.reply("\u6210\u529f\u5220\u9664NPC");
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"delete <selector>"})
    public void delete(ForgeCommandActor sender, EntitySelectorList<Entity> selector) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            NpcView npc = agent.getNpcView(entity.getStringUUID());
            if (npc != null) {
                npc.discard();
                sender.reply("\u6210\u529f\u5220\u9664NPC");
            } else {
                sender.reply("\u5220\u9664\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"discard <id>"})
    public void discard(ForgeCommandActor sender, @WithNpc String id) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        NpcView npc = agent.getNpcView(id);
        if (npc != null) {
            npc.discardAdditional();
            sender.reply("\u6210\u529f\u5220\u9664NPC\u9644\u52a0\u6570\u636e");
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"discard <selector>"})
    public void discard(ForgeCommandActor sender, EntitySelectorList<Entity> selector) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        selector.forEach(entity -> {
            NpcView npc = agent.getNpcView(entity.getStringUUID());
            if (npc != null) {
                npc.discardAdditional();
                sender.reply("\u6210\u529f\u5220\u9664NPC\u9644\u52a0\u6570\u636e");
            } else {
                sender.reply("\u5220\u9664\u5931\u8d25");
            }
        });
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"list"})
    public void list(ForgeCommandActor sender) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        sender.reply("\u5f53\u524d\u4e16\u754cNPC\u5217\u8868:");
        agent.getAllNpc().forEach(npc -> sender.reply(npc.getId()));
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"info <id>"})
    public void info(ForgeCommandActor sender, String id) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        NpcView npc = agent.getNpcView(id);
        if (npc != null) {
            sender.reply("NPC\u4fe1\u606f:");
            sender.reply("\u5b9e\u4f53: " + npc.getNpcType().getEntityType().toString());
            sender.reply("\u4f4d\u7f6e: " + npc.getOriginEntity().getX() + ", " + npc.getOriginEntity().getY() + ", " + npc.getOriginEntity().getZ());
            sender.reply("ID: " + npc.getId());
            sender.reply("\u7c7b\u578b: " + npc.getNpcType().getName());
            sender.reply("\u9644\u52a0\u6570\u636e: ");
            npc.getNpcData().forEach((name, value) -> sender.reply("- " + name + ": " + value));
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"config <id>"})
    public void config(ForgeCommandActor sender, String id) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(sender.getLevel());
        NpcView npc = agent.getNpcView(id);
        if (npc != null) {
            FreeEpicGames.LOGGER.warn("\u6ca1\u505a\u5b8c\u55b5\uff0c\u8bf6\u563f~");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"config <selector>"})
    public void config(ForgeCommandActor sender, EntitySelectorList<Entity> selector) {
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"reload"})
    public void reload(ForgeCommandActor sender) {
        sender.reply("\u6b63\u5728\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6...");
        NpcType.expire();
        NpcType.init();
        sender.reply("\u914d\u7f6e\u6587\u4ef6\u91cd\u8f7d\u5b8c\u6210");
    }
}

