/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.thexeler.freeepicgames.command.lamp.actor.ForgeCommandActor;
import org.thexeler.freeepicgames.command.lamp.annotations.RequiresOP;
import org.thexeler.freeepicgames.command.lamp.annotations.WithRaidType;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocation;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocationYZ;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocationZ;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.type.RaidType;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;

@Command(value={"fegraid"})
public class ModelRaidCommand {
    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"template create <name> <x1> <y1> <z1> <x2> <y2> <z2>"})
    public void templateCreate(ForgeCommandActor sender, String name, @WithTargetLocation int x1, @WithTargetLocationYZ int y1, @WithTargetLocationZ int z1, @WithTargetLocation int x2, @WithTargetLocationYZ int y2, @WithTargetLocationZ int z2) {
        if (RaidType.getType(name) == null) {
            JsonObject object = new JsonObject();
            object.addProperty("chunk_size_x", (Number)Math.abs(x2 - x1));
            object.addProperty("chunk_size_z", (Number)Math.abs(z2 - z1));
            RaidType.register(name, object);
            BlockPos start = new BlockPos(x1, y1, z1);
            BlockPos end = new BlockPos(x2, y2, z2);
            RaidType tempType = RaidType.getType(name);
            if (tempType != null) {
                tempType.updateConstruct(new ChunkPos(start), new ChunkPos(end));
                sender.reply("\u521b\u5efa\u6210\u529f:\u5df2\u521b\u5efa\u6a21\u677f" + name);
            } else {
                sender.reply("\u521b\u5efa\u5931\u8d25:\u6a21\u677f" + name + "\u6ce8\u518c\u5931\u8d25");
            }
        } else {
            sender.reply("\u521b\u5efa\u5931\u8d25:\u5df2\u5b58\u5728\u7684\u6a21\u677f" + name);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"template delete <name>"})
    public void templateDelete(ForgeCommandActor sender, @WithRaidType String name) {
        if (RaidType.unregister(name)) {
            sender.reply("\u5220\u9664\u6210\u529f:\u5df2\u5220\u9664\u6a21\u677f" + name);
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u6a21\u677f" + name);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"template update <name> <x> <y> <z>"})
    public void templateInfo(ForgeCommandActor sender, @WithRaidType String name, @WithTargetLocation int x, @WithTargetLocationYZ int y, @WithTargetLocationZ int z) {
        RaidType raidType = RaidType.getType(name);
        if (raidType != null) {
            BlockPos pos = new BlockPos(x, y, z);
            RaidInstanceView view = RaidInstanceView.getRaidInstanceFromChunk(new ChunkPos(pos));
            if (view != null) {
                raidType.updateConstruct(view);
                sender.reply("\u66f4\u65b0\u6210\u529f:\u5df2\u66f4\u65b0\u6a21\u677f" + name);
            } else {
                sender.reply("\u66f4\u65b0\u5931\u8d25:\u4e0d\u5904\u4e8e\u526f\u672c\u4e2d");
            }
        } else {
            sender.reply("\u66f4\u65b0\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u6a21\u677f" + name);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"template list"})
    public void templateList(ForgeCommandActor sender) {
        List<String> templates = RaidType.getAllTypeName();
        StringBuilder message = new StringBuilder("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u5171\u8ba1" + templates.size() + "\u4e2a\u526f\u672c\u6a21\u677f\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        templates.forEach(value -> message.append((String)value).append("\n"));
        message.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        sender.reply(message.toString());
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"instance create <type>"})
    public static void instanceCreate(ForgeCommandActor sender, @WithRaidType String type) {
        RaidType raidType = RaidType.getType(type);
        if (raidType != null) {
            RaidInstanceView view = raidType.create();
            view.build();
            sender.reply("\u521b\u5efa\u6210\u529f:\u5df2\u521b\u5efa\u526f\u672c" + view.getId());
        } else {
            sender.reply("\u521b\u5efa\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u6a21\u677f" + type);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"instance delete <id>"})
    public static void instanceDelete(ForgeCommandActor sender, String id) {
        GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
        RaidInstanceView view = agent.getRaidInstance(id);
        if (view != null) {
            view.destroy();
            sender.reply("\u5220\u9664\u6210\u529f:\u5df2\u5220\u9664\u526f\u672c" + id);
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u526f\u672c" + id);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"reload"})
    public static void reload(ForgeCommandActor sender) {
        sender.reply("\u6b63\u5728\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6...");
        RaidType.expire();
        RaidTreasureType.expire();
        RaidTreasureType.init();
        RaidType.init();
        sender.reply("\u914d\u7f6e\u6587\u4ef6\u91cd\u8f7d\u5b8c\u6210");
    }
}

