/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.thexeler.freeepicgames.database.agent.WorldNpcDataAgent;
import org.thexeler.freeepicgames.database.view.NpcView;
import org.thexeler.freeepicgames.events.NpcEvent;

public class NpcEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeath(LivingDeathEvent event) {
        NpcView view;
        NpcEvent.KilledEvent npcEvent;
        NpcView source = NpcView.getEntity(event.getSource().getEntity());
        if (source != null && ((NpcEvent.KilledEvent)NeoForge.EVENT_BUS.post((Event)(npcEvent = new NpcEvent.KilledEvent(source, (Entity)event.getEntity(), event.getSource())))).isCanceled()) {
            event.setCanceled(true);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity entity = livingEntity;
                entity.setHealth(1.0f);
            }
        }
        if ((view = NpcView.getEntity((Entity)event.getEntity())) != null) {
            NpcEvent.DeathEvent npcEvent2 = new NpcEvent.DeathEvent(view, event.getSource());
            if (!((NpcEvent.DeathEvent)NeoForge.EVENT_BUS.post((Event)npcEvent2)).isCanceled()) {
                view.discard();
            } else {
                event.setCanceled(true);
                Entity entity = view.getOriginEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity entity2 = (LivingEntity)entity;
                    entity2.setHealth(1.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        NpcView entity = NpcView.getEntity(event.getTarget());
        if (entity != null) {
            NeoForge.EVENT_BUS.post((Event)new NpcEvent.InteractEvent(entity, event.getEntity()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDamage(LivingIncomingDamageEvent event) {
        NpcView entity;
        NpcView source = NpcView.getEntity(event.getSource().getEntity());
        if (source != null) {
            NpcEvent.MeleeAttackEvent npcEvent = new NpcEvent.MeleeAttackEvent(source, (Entity)event.getEntity(), event.getSource(), event.getAmount(), event.getContainer());
            NeoForge.EVENT_BUS.post((Event)npcEvent);
            event.setAmount(npcEvent.getAmount());
        }
        if ((entity = NpcView.getEntity((Entity)event.getEntity())) != null) {
            NpcEvent.DamageEvent npcEvent = new NpcEvent.DamageEvent(entity, event.getSource(), event.getAmount(), event.getContainer());
            if (!((NpcEvent.DamageEvent)NeoForge.EVENT_BUS.post((Event)npcEvent)).isCanceled()) {
                event.setAmount(npcEvent.getAmount());
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityTick(ServerTickEvent.Post event) {
        event.getServer().getAllLevels().forEach(serverLevel -> {
            WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(serverLevel);
            agent.getAllNpc().forEach(entity -> {
                if (entity.getNpcType().isWeakAI()) {
                    entity.getMind().tick();
                }
                NeoForge.EVENT_BUS.post((Event)new NpcEvent.TickEvent((NpcView)entity));
            });
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onProjectileFire(EntityJoinLevelEvent event) {
        Projectile projectile;
        NpcView view;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile && (view = NpcView.getEntity((projectile = (Projectile)entity).getOwner())) != null) {
            NeoForge.EVENT_BUS.post((Event)new NpcEvent.RangeAttack.FireEvent(view, projectile));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onProjectileImpact(ProjectileImpactEvent event) {
        NpcView view;
        Entity entity = event.getProjectile().getOwner();
        if (entity != null && (view = NpcView.getEntity(entity)) != null) {
            NpcEvent.RangeAttack.HitEvent npcEvent = new NpcEvent.RangeAttack.HitEvent(view, event.getProjectile(), event.getRayTraceResult(), event.getEntity());
            event.setCanceled(((NpcEvent.RangeAttack.HitEvent)NeoForge.EVENT_BUS.post((Event)npcEvent)).isCanceled());
        }
    }
}

